/*******************************************************************************
 *	TmsDataClient.cpp	TMS API example code for a Data Client
 *			T.Barnaby,	BEAM Ltd,	2007-02-07
 *******************************************************************************
 *
 *	This is a very basic example of using the TmsApi from a clients perspective.
 *	It is designed to give an overview of using the API.
 */
#include <iostream>
#include <stdio.h>
#include <TmsD.h>
#include <TmsC.h>

using namespace Tms;
using namespace std;


// Function to reads some data
BError tmsTest(TmsProcess& tmsProcess){
	BError			err;
	DataInfo		dataInfo;
	Data			data;
	UInt32			cn = 0;
	BString			ct;
	
	// Find out the current cycle number and type
	if(err = tmsProcess.getCycleInfo(cn, ct)){
		return err.set(1, BString("Error: Getting Cycle Number: ") + err.getString());
	}
	
	printf("Getting data for cycles starting at cycle: %u\n", cn);

	for(; ; cn++){
		// Setup dataInfo
		printf("GetData: Cycle Number: %u\n", cn);
		dataInfo.cycleNumber	= cn;
		dataInfo.channel	= 1;
		dataInfo.cyclePeriod	= CyclePeriodEvent0;
		dataInfo.startTime	= 0;
		dataInfo.orbitNumber	= 0;
		dataInfo.bunchNumber	= 0;
		dataInfo.function	= DataFunctionRaw;
		dataInfo.argument	= 0;
		dataInfo.numValues	= 1024;
		dataInfo.beyondPeriod	= 1;

		if(err = tmsProcess.getData(dataInfo, data)){
			return err.set(1, BString("Error: Getting Data: ") + err.getString());
		}
		printf("Data: NumValues: %d\n", data.numValues);
	}
	
	return err;
}

int main(int argc, char** argv){
	BError			err;
	BString			host = "localhost";
	TmsProcess		tmsProcess;

	if(argc == 2)
		host = argv[1];

	// Connect to the Process service
	if(err = tmsProcess.connectService(BString("//") + host + "/tmsProcess")){
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}
	
	// Run a normal data gathering cycle as a normal client would.
	if(err = tmsTest(tmsProcess)){	
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}
		
	return 0;
}
