/*******************************************************************************
 *	Client.cc	HomeNet RPC protocol test client
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <BString.h>
#include <TestD.h>
#include <TestC.h>

int main(int argc, char** argv){
	Test::Obj1	client("test");
	BError		err;
	Int32		a1 = 33;
	Test::Data	a2;
	BArray<Int32>	a3(4, 44);
	UInt32		i;
	UInt32		v = 0;
	int		n = 0;

	err = client.connectService("test");
	std::cout << "Result: " << err.getString() << "\n";
	
	printf("Ping\n");
	err = client.ping(v);
	std::cout << "Result: " << err.getString() << " Version: " << v << "\n";
	
	printf("Test1\n");
	err = client.setData(a1, a2);
	std::cout << "Result: " << err.getString() << "\n";
	err = client.getData(a1, a2);
	std::cout << "Result: " << err.getString() << "\n";


	printf("Test2\n");
	a1 = 33;
	err = client.setData1(a1, a3);
	a1 = 0;
	a3.clear();
	
	err = client.getData1(a1, a3);
	printf("a1: %d\n", a1);
	printf("a3: "); for(i = 0; i < a3.size(); i++) printf("%d, ", a3[i]); printf("\n");

	if(argc > 1){
		if(atoi(argv[1]) == 1){
			while(1){
				err = client.getData(a1, a2);
				std::cout << "getData: " << n++ << " result: " << err.getString() << "\n";
			}
		}
		else{
			while(1){
				err = client.getData1(a1, a3);
				std::cout << "getData1: " << n++ << " result: " << err.getString() << "\n";
			}
		}	
	}
	
	return 0;
}
