/*******************************************************************************
 *	BPoll.h		File poll class
 *			T.Barnaby,	BEAM Ltd,	01/4/05
 *******************************************************************************
 */
#ifndef BPOLL_H
#define BPOLL_H	1

#include <BList.h>
#include <BError.h>
#include <sys/poll.h>

/// \brief This class provides an interface for polling a number of file descriptors.
/// It uses round robin polling
class BPoll {
public:
	typedef struct pollfd PollFd;

			BPoll();
			~BPoll();
			
	void		append(int fd, int events = POLLIN|POLLERR|POLLHUP|POLLNVAL);	///< Append a file descriptor to polling list
	void		delFd(int fd);							///< Remove a file descriptor from polling list

	BError		doPoll(int& fd, int timeoutUs = -1);				///< Perform polling operation

	int		getPollFdsNum();
	PollFd*		getPollFds();
	void		clear();
private:
	int		nextFd(int i);
	
	int		ofdsNum;			///< The number of FD's in list
	PollFd*		ofds;				///< The list of poll fd's
	int		ofdsNext;			///< The next list entry for round robin polling
};

#endif
