/*******************************************************************************
 *	BMutex.h		BMutex Classes
 *			T.Barnaby,	BEAM Ltd,	1/11/02
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BMUTEX_H
#define BMUTEX_H	1

#include <pthread.h>

/// Mutex class
class BMutex {
public:
	enum Type	{ Normal, Recursive };

			BMutex(Type type =  Normal);
			BMutex(const BMutex& mutex);
			~BMutex();
	
	int		lock();			///< Set lock, wait as necessary
	int		timedLock(int timeoutUs);	///< Set lock, wait as necessary but timeout after given time
	int		unlock();		///< Unlock the lock
	int		tryLock();		///< Test the lock
	
	BMutex&		operator=(const BMutex& mutex);
private:
	pthread_mutex_t	omutex;
};

class BMutexLock {
public:
			BMutexLock(BMutex& lock, int doLock = 0) : olock(lock)	{ if(doLock) olock.lock();	}
			~BMutexLock()				{ olock.unlock();		}
	int		lock()					{ return olock.lock();		}
	int		unlock()				{ return olock.unlock();	}
private:
	BMutex&		olock;
};
#endif
