-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_v4_dm_iob.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
--
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module places the data mask signals into the IOBs.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity mem_interface_small_v4_dm_iob is
port (
        CLK90           : in std_logic;
        MASK_DATA_RISE  : in std_logic;
        MASK_DATA_FALL  : in std_logic;
        DDR_DM          : out std_logic
      );

end entity;

architecture arc_v4_dm_iob of mem_interface_small_v4_dm_iob is

component ODDR
generic(
    DDR_CLK_EDGE : string := "SAME_EDGE";
    SRTYPE       : string := "SYNC"
    );
port(
    Q           : out std_ulogic;
    C           : in  std_ulogic;
    CE          : in  std_ulogic;
    D1          : in  std_ulogic;
    D2          : in  std_ulogic;
    R           : in  std_ulogic;
    S           : in  std_ulogic
  );
end component;

component OBUF
port(
        I : in std_logic;
        O : out std_logic
       );

end component;

signal  dm_out  : std_logic;

signal  vcc  : std_logic;
signal  gnd  : std_logic;



begin

  vcc         <= '1';
  gnd         <= '0';


oddr_dm : ODDR
generic map(
    DDR_CLK_EDGE => "SAME_EDGE",
    SRTYPE       => "SYNC"
    )
port map (
               Q        =>      dm_out,
               C        =>      CLK90,
               CE       =>      vcc,
               D1       =>      MASK_DATA_RISE,
               D2       =>      MASK_DATA_FALL,
               R        =>      gnd,
               S        =>      gnd
               );

obuf_dm : OBUF
port map (
               I        =>      dm_out,
               O        =>      DDR_DM
                  );

end arc_v4_dm_iob;
