-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_parameters_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- Device: Virtex-4
-- Design Name: DDR2_SDRAM
-- Description :  According to the user inputs the parameters are defined here. 
--            These parameters are used for the generic memory interface code. 
--          Various parameters are address widths, data widths, timing 
--          parameters according to the frequency selected by the user and 
--          some internal parameters also.
-------------------------------------------------------------------------------

library IEEE;
use ieee.std_logic_1164.all;  
use ieee.std_logic_unsigned.all;

package mem_interface_small_parameters_0 is

--counter values in the controller in tCK units 
--write latency (WL) = Read Latency (RL) - 1 = AL + CL -1 
--Read Latency (RL ) = AL + CL 

constant   data_width                                : INTEGER   :=  32;
constant   data_strobe_width                         : INTEGER   :=  4;
constant   data_mask_width                           : INTEGER   :=  4;
constant   clk_width                                 : INTEGER   :=  2;
constant   fifo                                      : INTEGER   :=  2;
constant   ecc_cntrl_bits                            : INTEGER   :=  0;
constant   ReadEnable                                : INTEGER   :=  1;
constant   cs_width                                  : INTEGER   :=  1;
constant   odt_width                                 : INTEGER   :=  1;
constant   cke_width                                 : INTEGER   :=  1;
constant   deep_memory                               : INTEGER   :=  1;
constant   row_address                               : INTEGER   :=  13;
constant   column_address                            : INTEGER   :=  10;
constant   bank_address                              : INTEGER   :=  3;
constant   memory_width                              : INTEGER   :=  8;
constant   registered                                : INTEGER   :=  0;
constant   unbuffered                                : INTEGER   :=  1;
constant   col_ap_width                              : INTEGER   :=  11;
constant   DatabitsPerStrobe                         : INTEGER   :=  8;
constant   DatabitsPerMask                           : INTEGER   :=  8;
constant   no_of_CS                                  : INTEGER   :=  1;
constant   RESET                                     : INTEGER   :=  0;
constant   data_mask                                 : INTEGER   :=  1;
constant   ecc_enable                                : INTEGER   :=  0;
constant   ecc_disable                               : INTEGER   :=  1;
constant   ecc_width                                 : INTEGER   :=  0;
constant   dq_width                                  : INTEGER   :=  32;
constant   dm_width                                  : INTEGER   :=  4;
constant   tb_enable                                 : INTEGER   :=  0;
constant   tb_disable                                : INTEGER   :=  1;
constant   dcm_enable                                : INTEGER   :=  1;
constant   dcm_disable                               : INTEGER   :=  0;
constant   low_frequency                             : INTEGER   :=  0;
constant   high_frequency                            : INTEGER   :=  1;
constant   foundation_ise                            : INTEGER   :=  1;
constant   Data8PerReadEnable                        : INTEGER   :=  1;
constant   Data4PerReadEnable                        : INTEGER   :=  0;
constant   burst_length                                     : std_logic_vector(2 downto 0) := "010";
constant   burst_type                                       : std_logic :=  '0';
constant   cas_latency_value                                : std_logic_vector(2 downto 0) := "100";
constant   mode                                             : std_logic :=  '0';
constant   dll_rst                                          : std_logic :=  '0';
constant   write_recovery                                   : std_logic_vector(2 downto 0) := "100"; --15ns
constant   pd_mode                                          : std_logic :=  '0';
constant   load_mode_register                        : std_logic_vector(12 downto 0) := "0100001000010";


constant   output                                           : std_logic :=  '0';
constant   rdqs_ena                                         : std_logic :=  '0';
constant   dqs_n_ena                                        : std_logic :=  '0';
constant   ocd_operation                                    : std_logic_vector(2 downto 0) := "000";
constant   odt_enable                                       : std_logic_vector(1 downto 0) := "10";
constant   additive_latency_value                           : std_logic_vector(2 downto 0) := "000";
constant   dll_ena                                          : std_logic :=  '0';
constant   op_drive_strength                                : std_logic :=  '0';
constant   ext_load_mode_register                    : std_logic_vector(12 downto 0) := "0000001000000";

constant   chip_address                              : INTEGER   :=  1;
constant   rcd_count_value                           : std_logic_vector(2 downto 0) := "100"; -- 15ns
constant   ras_count_value                           : std_logic_vector(3 downto 0) := "1100";-- 40ns
constant   mrd_count_value                           : std_logic := '1';
constant   rp_count_value                             : std_logic_vector(2 downto 0) := "100"; -- 15ns
constant   rfc_count_value                            : std_logic_vector(5 downto 0) := "100000"; --128ns
constant   trtp_count_value                           : std_logic_vector(2 downto 0) := "010";  --7.5ns
constant   twr_count_value                            : std_logic_vector(2 downto 0) := "100";  --15 ns
constant   twtr_count_value                      : std_logic_vector(2 downto 0) := "010";       --7.5ns
constant   max_ref_width                                   : INTEGER   :=  7;
constant   max_ref_cnt                     : std_logic_vector(6 downto 0) := "1011111";
constant   Phy_Mode                                  : std_logic :=  '1';

constant    cs_h0               : std_logic_vector(3 downto 0)  := "0000";  
constant    cs_h1               : std_logic_vector(3 downto 0)  := "0001";  
constant    cs_h2               : std_logic_vector(3 downto 0)  := "0010";  
constant    cs_h3               : std_logic_vector(3 downto 0)  := "0011";  
constant    cs_h5               : std_logic_vector(3 downto 0)  := "0101";  
constant    cs_h6               : std_logic_vector(3 downto 0)  := "0110";  
constant    cs_h7               : std_logic_vector(3 downto 0)  := "0111";  
constant    cs_hA               : std_logic_vector(3 downto 0)  := "1010";  
constant    cs_hB               : std_logic_vector(3 downto 0)  := "1011";  
constant    cs_hD               : std_logic_vector(3 downto 0)  := "1101";  
constant    cs_hE               : std_logic_vector(3 downto 0)  := "1110";  
constant    cs_hF               : std_logic_vector(3 downto 0)  := "1111" ;  
constant    cs_D100             : std_logic_vector(7 downto 0)  := X"64"; 
constant    cs_D1000            : std_logic_vector(11 downto 0) := X"3E8";
constant    add_const1          : std_logic_vector(15 downto 0) := X"0100" ;
constant    add_const2          : std_logic_vector(15 downto 0) := X"0380" ; 
constant    add_const3          : std_logic_vector(15 downto 0) := X"0000" ; 
constant    add_const4          : std_logic_vector(15 downto 0) := X"FBFF" ; 
constant    add_const5          : std_logic_vector(15 downto 0) := X"FFFF" ; 

end package mem_interface_small_parameters_0 ;
