/*******************************************************************************
 *	DataAcquire.cc	DataAcquire process
 *			T.Barnaby,	BEAM Ltd,	2007-02-07
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <DataAcquire.h>
#include <SigGen.h>
#include <Control.h>
#include <main.h>
#include <Debug.h>

DataAcquire::DataAcquire(Control& control) : ocontrol(control){
}

DataAcquire::~DataAcquire(){
}

BError DataAcquire::init(){
	BError		err;

	return err;
}

BError DataAcquire::getData(DataInfo dataInfo, Data& data){
	BError		err;

	if(ocontrol.osimulate){
		err = getSimData(dataInfo, data);
	}
	else {
		err.set(ErrorNotImplemented, BString(__PRETTY_FUNCTION__) + " has not been implemented");
	}
	
	return err;
}

BError DataAcquire::requestData(DataInfo dataInfo){
	BError		err;

	return err;
}

BError DataAcquire::getSimData(DataInfo dataInfo, Data& data){
	BError		err;
	SigGenBeam	sigBeam;
	BUInt32		i;
	Sample*		samples;
	static Data	dataCache;
	
	if(dataCache.dataValues.size() != dataInfo.numValues){
		samples = new Sample[dataInfo.numValues];
		sigBeam.config(125000000, 437000, 8, 0x3C, 0, 0, 1.0);
		sigBeam.generateIntegrated(samples, dataInfo.numValues);

		dataCache.numValues = dataInfo.numValues;
		dataCache.dataType = 0;
		dataCache.numBunches = 4;
		dataCache.numChannels = 1;
		dataCache.dataValues.resize(dataInfo.numValues);

		for(i = 0; i < dataInfo.numValues; i++){
			dataCache.dataValues[i].sigma = BInt16(32767.0 * samples[i]);
			dataCache.dataValues[i].deltaX = BInt16(0.2 * 32767.0 * samples[i]);
			dataCache.dataValues[i].deltaY = BInt16(-0.1 * 32767.0 * samples[i]);
		}

		delete [] samples;
	}
	
	data = dataCache;

	return err;
}
