/*******************************************************************************
 *	Node.h		C Node Object
 *			T.Barnaby,	BEAM Ltd,	20/2/02
 *******************************************************************************
 */
#ifndef NODE_HH
#define NODE_HH

#include <BString.h>
#include <BList.h>


/*
 *	Node class:	Main storage node
 */
class Node {
public:
	enum NodeType { TNONE, TLIST, TIDENT, TTYPE, TFUNC, TFUNCPARAM,
		TINTERFACE, TMODULE, TSTRUCT, TSTRUCTITEM, TTYPELIST, TTYPEARRAY, TDIR,
		TTYPEDOMAIN, TCOMMENT, TENUM, TAPIVERSION };
			Node(NodeType type, BString name);
	virtual		~Node();
		
	NodeType	nodeType();
	BString		name();
	BList<Node*>&	nodes();
	Node*		node(int n);

	Node*		append(Node* n);
	Node*		appendList(Node* n);
	static BString	nodeTypeName(NodeType t);
	
	// Test interface
	BString		str();
	BString		asStr();
private:
	NodeType	onodeType;
	BString		oname;
	BList<Node*>	onodes;
};

class NodeOp1 : public Node {
public:
			NodeOp1(NodeType nodeType, BString name, Node* arg1);
};

class NodeOp2 : public Node {
public:
			NodeOp2(NodeType nodeType, BString name, Node* arg1, Node* arg2);
};

class NodeOp3 : public Node {
public:
			NodeOp3(NodeType nodeType, BString name, Node* arg1, Node* arg2, Node* arg3);
};

class NodeOp4 : public Node {
public:
			NodeOp4(NodeType nodeType, BString name, Node* arg1, Node* arg2, Node* arg3, Node* arg4);
};
#endif
