/*******************************************************************************
 *	BArray.h	BEAM Array
 *			T.Barnaby,	BEAM Ltd,	2007-02-06
 *******************************************************************************
 */
#ifndef BArray_H
#define BArray_H	1

#include <BTypes.h>
#include <vector>

/// Template based Array class.
/// This is based on the Standard C++ library vector class and has all of the
/// functionality of that class.
template <class T> class BArray : public std::vector<T> {
public:
			BArray() : std::vector<T>() {}
			BArray(BSize size, T value = T()) : std::vector<T>(size, value) {}
			BArray(const BArray& array) : std::vector<T>(array) {}
#ifdef OLD_GXX
	T*		data(){
				return &(*std::vector<T>::begin());
			}
#endif
private:
};

#endif
