/*
* Title:	TestWin.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Tms selftest Display
*
* Mod Rec:
*
*/

#include <TestWin.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qvgroupbox.h>
#include <qmessagebox.h>

TestWin::TestWin(QWidget* w,Control& c) : ocontrol(c)  {
	QVGroupBox*	t = new QVGroupBox("Test",this,"Test");
			oresults = new QTextEdit(t);
	QPushButton*	p = new QPushButton("Run Server Self Test",t);

	p->setMaximumWidth(200);
	connect(p,SIGNAL(clicked()),this,SLOT(runTest()));
}
	
TestWin::~TestWin() {}

	
void TestWin::show() {
	QWidget::show();
}

void TestWin::runTest() {
	BError		err;
	BIter		i;
	BList<BError>	l;	
	if (err = ocontrol.runTest(l)) {
		warningDialog("Run Test",err);
		return;
	}
	oresults->clear();
	for (l.start(i);! l.isEnd(i);l.next(i)) {
		BString	s;
		s.printf("%d: %s\n", l[i].getErrorNo(), l[i].getString().retStr());
		oresults->append(s.retStr());
	}
}
void	TestWin::warningDialog(BString title, BError err){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + err.getString() + "</p>";
	QMessageBox::warning(this, "Warning", m.retStr());
}

	
