-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_controller_iobs_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module puts the memory control signals like address, 
-- 			   bank address, row address strobe, column address strobe, 
--			   write enable and clock enable in the IOBs.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

entity mem_interface_small_controller_iobs_0 is 
port ( 
       ctrl_ddr2_address          : in std_logic_vector(row_address-1 downto 0);
       ctrl_ddr2_ba               : in std_logic_vector(bank_address-1 downto 0);
       ctrl_ddr2_ras_L           : in std_logic;
       ctrl_ddr2_cas_L             : in std_logic;
       ctrl_ddr2_we_L              : in std_logic;
       ctrl_ddr2_cs_L              : in std_logic_vector(cs_width-1 downto 0);  
       ctrl_ddr2_cke              : in std_logic_vector(cke_width-1 downto 0);  
       ctrl_ddr2_odt              : in std_logic_vector(odt_width-1 downto 0);
       
       DDR_ADDRESS     : out std_logic_vector(row_address-1 downto 0);
       DDR_BA          : out std_logic_vector(bank_address-1 downto 0);
       DDR_RAS_L       : out std_logic;
       DDR_CAS_L       : out std_logic;
       DDR_WE_L        : out std_logic;
       DDR_ODT         : out std_logic_vector(odt_width-1 downto 0);
       DDR_CKE         : out std_logic_vector(cke_width-1 downto 0);    
       DDR_cs_L          : out std_logic_vector(cs_width-1 downto 0)   
       
       );
end entity;       

architecture arc_controller_iobs of mem_interface_small_controller_iobs_0 is



component OBUF 
port(
        I : in std_logic;
        O : out std_logic
       );

end component;


begin
     
OBUF_ras : OBUF 
          port map(
          		   I =>ctrl_ddr2_ras_L,	                           
                     O => DDR_RAS_L       
                  );          
OBUF_cas : OBUF 
          port map(
          		   I => ctrl_ddr2_cas_L,	                           
                     O => DDR_CAS_L       
                  );          
OBUF_we : OBUF 
          port map(
          		   I => ctrl_ddr2_we_L,	                           
                     O => DDR_WE_L       
                  );  


OBUF_cs0 : OBUF
    port map (
                 I  => ctrl_ddr2_cs_L(0),
                 O  => ddr_cs_L(0)
               );


OBUF_cke0 : OBUF
    port map (
                I => ctrl_ddr2_cke(0),
                O => DDR_CKE(0)
               );


OBUF_odt0 : OBUF
      port map (
              I => ctrl_ddr2_odt(0),
                O => DDR_ODT(0)
               );


       
OBUF_r0 : OBUF
    port map (
                 I  => ctrl_ddr2_address(0),
                 O  => DDR_ADDRESS(0)
               );

OBUF_r1 : OBUF
    port map (
                 I  => ctrl_ddr2_address(1),
                 O  => DDR_ADDRESS(1)
               );

OBUF_r2 : OBUF
    port map (
                 I  => ctrl_ddr2_address(2),
                 O  => DDR_ADDRESS(2)
               );

OBUF_r3 : OBUF
    port map (
                 I  => ctrl_ddr2_address(3),
                 O  => DDR_ADDRESS(3)
               );

OBUF_r4 : OBUF
    port map (
                 I  => ctrl_ddr2_address(4),
                 O  => DDR_ADDRESS(4)
               );

OBUF_r5 : OBUF
    port map (
                 I  => ctrl_ddr2_address(5),
                 O  => DDR_ADDRESS(5)
               );

OBUF_r6 : OBUF
    port map (
                 I  => ctrl_ddr2_address(6),
                 O  => DDR_ADDRESS(6)
               );

OBUF_r7 : OBUF
    port map (
                 I  => ctrl_ddr2_address(7),
                 O  => DDR_ADDRESS(7)
               );

OBUF_r8 : OBUF
    port map (
                 I  => ctrl_ddr2_address(8),
                 O  => DDR_ADDRESS(8)
               );

OBUF_r9 : OBUF
    port map (
                 I  => ctrl_ddr2_address(9),
                 O  => DDR_ADDRESS(9)
               );

OBUF_r10 : OBUF
    port map (
                 I  => ctrl_ddr2_address(10),
                 O  => DDR_ADDRESS(10)
               );

OBUF_r11 : OBUF
    port map (
                 I  => ctrl_ddr2_address(11),
                 O  => DDR_ADDRESS(11)
               );

OBUF_r12 : OBUF
    port map (
                 I  => ctrl_ddr2_address(12),
                 O  => DDR_ADDRESS(12)
               );


OBUF_b0 : OBUF
    port map (
                I => ctrl_ddr2_ba(0),
                O => DDR_BA(0)
               );

OBUF_b1 : OBUF
    port map (
                I => ctrl_ddr2_ba(1),
                O => DDR_BA(1)
               );

OBUF_b2 : OBUF
    port map (
                I => ctrl_ddr2_ba(2),
                O => DDR_BA(2)
               );
      

 
end arc_controller_iobs;
