/*******************************************************************************
 *	BArray.h	BEAM Array
 *			T.Barnaby,	BEAM Ltd,	2007-02-06
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BArray_H
#define BArray_H	1

#include <BTypes.h>
#include <vector>
#include <algorithm>

/// Template based Array class.
/// This is based on the Standard C++ library vector class and has all of the
/// functionality of that class.
template <class T> class BArray : public std::vector<T> {
public:
	typedef int	(*SortFunc)(T& a, T& b);		///< Prototype for sorting function

			BArray() : std::vector<T>() {}
			BArray(BSize size, T value = T()) : std::vector<T>(size, value) {}
			BArray(const BArray& array) : std::vector<T>(array) {}
#ifdef OLD_GXX
	T*		data(){
				return &(*std::vector<T>::begin());
			}
#endif
	BUInt		number() const { return std::vector<T>::size(); }
	void		append(const T& value){	std::vector<T>::insert(std::vector<T>::end(), value);	}
	void		append(const BArray<T>& array);
	void		insert(BUInt pos, const T& value){ std::vector<T>::insert(typename std::vector<T>::iterator(this->_M_impl._M_start + pos), value); }
	void		del(BUInt pos, BUInt num = 1){	std::vector<T>::erase(std::vector<T>::begin() + pos, std::vector<T>::begin() + pos + num); }
	T&		rear(){ return std::vector<T>::back(); }
//	void		sort(SortFunc func){	std::sort(std::vector<T>::begin(), std::vector<T>::end(), func);	}
	void		sort(){	std::sort(std::vector<T>::begin(), std::vector<T>::end());	}
private:
};

template <class T> void BArray<T>::append(const BArray<T>& array){
	BUInt	l = BArray<T>::size();
	
	BArray<T>::resize(l + array.size());
	memcpy(&BArray<T>::data()[l], array.data(), sizeof(T) * array.size());
}

// Macros
#define BArrayLoop(list, i)	for(BUInt i = 0; i < list.number(); i++)

#endif
