/*******************************************************************************
 *	TmsPuApi.h	Produced by Bidl
 *******************************************************************************
 */
#ifndef TmsPuApi_H
#define TmsPuApi_H	1

#include <BString.h>
#include <BList.h>
#include <BArray.h>
#include <TmsS.h>

using namespace Tms;

class Control;

class PuControlServer : public Tms::PuControlService {
public:
		PuControlServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError init();
	BError setProcessPriority(BUInt32 priority);
	BError configure(BUInt32 ring, ConfigInfo configInfo);
	BError setControlInfo(CycleParam params);
	BError setNextCycle(UInt32 cycleNumber, BString cycleType);
	BError test(BList<BError>& errors);
	BError getStatus(BList<NameValue>& statusList);
	BError getStatistics(BList<NameValue>& statsList);
	BError getMasterPuChannel(PuChannel& puChannel);

	BError setTestMode(PuChannel puChannel, UInt32 testOutput, UInt32 timingDisableMask);
	BError setTimingSignals(PuChannel puChannel, UInt32 timingSignals);
	BError captureDiagnostics(PuChannel puChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data);
	BError setTestData(PuChannel puChannel, Int32 on, BArray<UInt32> data);	///< This function will set a PU channel to sample data from memory rather than the ADC's
	BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig);
	BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig);
private:
	Control&	ocontrol;
};

class PuProcessServer : public Tms::PuProcessService {
public:
		PuProcessServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError getStatus(PuChannel puChannel, PuStatus& puStatus);
	BError getCycleInformation(UInt32 cycleNumber, CycleInformation& cycleInformation);
	BError getData(PuChannel puChannel, DataInfo dataInfo, Data& data, UInt32& orbitNumber);

	BError addEventServer(BString name);
	BError requestData(PuChannel puChannel, DataInfo dataInfo);
private:
	Control&	ocontrol;
};

#endif
