/*******************************************************************************
 *	SigRecv.cc	SigRecv service
 *			T.Barnaby,	BEAM Ltd,	8/3/05
 *******************************************************************************
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <iostream>
#include <netinet/in.h>

#include <Boap.h>

class Service : public BoapServiceObject {
public:
		Service(BoapServer& server, BString name) : BoapServiceObject(server, name){}
	BError	processEvent(BString objectName, BString name, Int32 arg){
		BError	err;
		
		printf("Service::processEvent(%s, %s, %d)\n", objectName.retStr(), name.retStr(), arg);
		return err;
	}
};

int main(int argc, char** argv){
	BoapServer	server;
	Service		service(server, "sigrecv");
	BError		err;

	
	if(err = server.init()){
		std::cerr << err.getString() << "\n";
		return 1;
	}

	server.run();

	return 0;
}
