/*******************************************************************************
 *	BNameValue.h	Beam Name Vlaue Object
 *			T.Barnaby,	BEAM Ltd,	16/8/00
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BNAMEVALUE_H
#define BNAMEVALUE_H	1

#include	<BList.h>
#include	<BString.h>

template <class T> class BNameValue {
public:
			BNameValue(){
			}
			BNameValue(BString name, const T& value){
				oname = name;
				ovalue = value;
			}

	BString		getName(){	return oname; }
	T&		getValue(){ return ovalue; }
private:
	BString		oname;
	T		ovalue;
};

template <class T> class BNameValueList : public BList< BNameValue<T> > {
public:
	T*		find(BString name){
				for(BIter i = this->begin(); !this->isEnd(i); this->next(i)){
					if(this->get(i).getName() == name)
						return &this->get(i).getValue();
				}
				return 0;
			}
	BIter		findPos(BString name){
				for(BIter i = this->begin(); !this->isEnd(i); this->next(i)){
					if(this->get(i).getName() == name)
						return i;
				}
				return this->onodes;
			}
};

#endif
