#!/usr/bin/env python
################################################################################
#	PlotFile.py	Signal plotter
#			T.Barnaby,	BEAM Ltd,	2006-02-10
################################################################################
#

import os
import sys
import time
import getopt

def plotSig(fileName, toFile=""):
	n=10
	cmd="set multiplot; set format x ''; set lmargin 8; set bmargin 0; set tmargin 1; set grid noytics xtics;";
	
	for i in range(0, n - 1):
		o = float(n - i - 1) / n;
		s = float(1) / n;
		if(i != 4):
			cmd = cmd + "set yrange [-0.1:1.1];";
		else:
			cmd = cmd + "set yrange [-100:1000];";
		cmd = cmd + "set origin 0," + str(o) + "; set size 1," + str(s) + ";"
		cmd = cmd + "plot '" + fileName + "' using " + str(i + 1) + " with lines;"

	cmd = cmd + "unset multiplot; pause -1; pause 1000;"

	print cmd
#	echo $cmd | gnuplot -
	f = os.popen("gnuplot -", "w");
	f.write(cmd);
	f.flush();
#	time.sleep(1)

def usage():
	print "Usage: filePlot.py [ -p <file> ] <signal file>";
	print "		-p <file>	- Create graphics file (.png)"
	
def main():
	toFile		= "";
				
	try:
		opts, args = getopt.getopt(sys.argv[1:], "p:");
	except getopt.GetoptError:
        	# print help information and exit:
        	usage();
        	sys.exit(1);

	for o in opts:
		if(o[0] == "-p"):
			toFile = o[1];
		else:
			usage();

	if(len(args) != 1):
		usage();
		sys.exit(1);

	plotSig(args[0]);
		
	sys.exit(0);
	
if __name__ == "__main__":
	main();
