-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_data_tap_inc.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description :  The tap logic for calibration of the memory data with respect 
-- 			to FPGA clock is provided here. According to the edge detection 
-- 			or not the taps in the IDELAY element of the Virtex4 devices 
--			are either increased or decreased.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
-- pragma translate_off
--library UNISIM;
--use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

entity mem_interface_small_data_tap_inc is
port (
      CAL_CLK              : in std_logic;
      RESET                : in std_logic;
      DQS_SEL_DONE         : in std_logic;
      DATA_DLYINC          : out std_logic; 
      DATA_DLYCE           : out std_logic;  
      DATA_DLYRST          : out std_logic;
      DATA_TAP_SEL_DONE    : out std_logic;
      VALID_DATA_TAP_COUNT : in std_logic;
      DATA_TAP_COUNT       : in std_logic_vector(5 downto 0)
     );

end entity;

architecture arc_data_tap_inc of mem_interface_small_data_tap_inc is

signal data_dlyinc_clk0          : std_logic;
signal data_dlyce_clk0           : std_logic;
signal data_dlyrst_clk0          : std_logic;
signal data_tap_inc_counter      : std_logic_vector(5 downto 0);
signal data_tap_sel_clk          : std_logic;
signal data_tap_sel_r1           : std_logic;
signal DQS_SEL_DONE_r            : std_logic;
signal VALID_DATA_TAP_COUNT_r : std_logic;
begin

DATA_TAP_SEL_DONE <= data_tap_sel_r1;
DATA_DLYINC       <= data_dlyinc_clk0;
DATA_DLYCE        <= data_dlyce_clk0;
DATA_DLYRST       <= data_dlyrst_clk0;

  process(CAL_CLK)
   begin
     if (CAL_CLK'event and CAL_CLK = '1') then
     if (RESET = '1') then
       DQS_SEL_DONE_r <= '0';
     elsif(DQS_SEL_DONE = '1') then
       DQS_SEL_DONE_r <= '1';
     else
      DQS_SEL_DONE_r <= DQS_SEL_DONE_r;
     end if;
     end if;
   end process;

   process(CAL_CLK)
   begin
     if (CAL_CLK'event and CAL_CLK = '1') then
       if (RESET = '1') then
         data_tap_sel_clk  <= '0';
       elsif (data_tap_inc_counter(5 downto 0) = "000001") then
         data_tap_sel_clk  <= '1';
       end if;
     end if;
   end process;
   
   process(CAL_CLK)
   begin
     if (CAL_CLK'event and CAL_CLK = '1') then
       if (RESET = '1') then
         data_tap_sel_r1    <= '0';
         VALID_DATA_TAP_COUNT_r <= '0';
       else
         data_tap_sel_r1    <= data_tap_sel_clk;
         VALID_DATA_TAP_COUNT_r <= VALID_DATA_TAP_COUNT;
       end if;
     end if;
   end process;
   
   process(CAL_CLK)
   begin
     if (CAL_CLK'event and CAL_CLK = '1') then
       if (RESET = '1' or DQS_SEL_DONE_r = '0') then                           -- Data IDELAY in no change mode
         data_dlyinc_clk0                 <= '0';
         data_dlyce_clk0                  <= '0';
         data_dlyrst_clk0                 <= '1';
         data_tap_inc_counter(5 downto 0) <= "000000";
       elsif (VALID_DATA_TAP_COUNT_r = '1') then
         data_dlyinc_clk0                 <= '0';
         data_dlyce_clk0                  <= '0';
         data_dlyrst_clk0                 <= '0';
         data_tap_inc_counter(5 downto 0) <= DATA_TAP_COUNT(5 downto 0);
       elsif (data_tap_inc_counter(5 downto 0) /= "000000") then -- Data IDELAY incremented
         data_dlyinc_clk0                 <= '1';
         data_dlyce_clk0                  <= '1';
         data_dlyrst_clk0                 <= '0';
         data_tap_inc_counter(5 downto 0) <= data_tap_inc_counter(5 downto 0) - "000001";
       else                                             -- Data IDELAY no change mode
         data_dlyinc_clk0                 <= '0';
         data_dlyce_clk0                  <= '0';
         data_dlyrst_clk0                 <= '0';
         data_tap_inc_counter(5 downto 0) <= "000000";
       end if;
     end if;
   end process;

end arc_data_tap_inc; 