-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_RAM_D_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : Contains the distributed RAM which stores IOB output data 
-- 			   that is read from the memory.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;
--
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

entity mem_interface_small_RAM_D_0 is 
port (
      DPO    : out std_logic_vector(memory_width-1 downto 0);  
      A0     : in std_logic;   
      A1     : in std_logic;   
      A2     : in std_logic;   
      A3     : in std_logic;   
      D      : in std_logic_vector(memory_width-1 downto 0);    
      DPRA0  : in std_logic;
      DPRA1  : in std_logic;
      DPRA2  : in std_logic;
      DPRA3  : in std_logic;
      WCLK   : in std_logic; 
      WE     : in std_logic
      );

end entity;

architecture arc_RAM of mem_interface_small_RAM_D_0 is

component RAM16X1D
   port (
    DPO   : out std_ulogic;
    SPO   : out std_ulogic;
    A0    : in  std_ulogic;
    A1    : in  std_ulogic;
    A2    : in  std_ulogic;
    A3    : in  std_ulogic;
    D     : in  std_ulogic;
    DPRA0 : in  std_ulogic;
    DPRA1 : in  std_ulogic;
    DPRA2 : in  std_ulogic;
    DPRA3 : in  std_ulogic;
    WCLK  : in  std_ulogic;
    WE    : in  std_ulogic
    );
end component;

begin

RAM16X1D0 : RAM16X1D
    port map ( D     => D(0),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(0)
            );


RAM16X1D1 : RAM16X1D
    port map ( D     => D(1),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(1)
            );


RAM16X1D2 : RAM16X1D
    port map ( D     => D(2),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(2)
            );


RAM16X1D3 : RAM16X1D
    port map ( D     => D(3),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(3)
            );


RAM16X1D4 : RAM16X1D
    port map ( D     => D(4),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(4)
            );


RAM16X1D5 : RAM16X1D
    port map ( D     => D(5),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(5)
            );


RAM16X1D6 : RAM16X1D
    port map ( D     => D(6),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(6)
            );


RAM16X1D7 : RAM16X1D
    port map ( D     => D(7),
               WE    => WE,
               WCLK  => WCLK,
               A0    => A0,
               A1    => A1,
               A2    => A2,
               A3    => A3,
               DPRA0 => DPRA0,
               DPRA1 => DPRA1,
               DPRA2 => DPRA2,
               DPRA3 => DPRA3,
               SPO   => open,
               DPO   => DPO(7)
            );

 


end arc_RAM; 
