/*******************************************************************************
 *	Sig.cc		Send signal service
 *			T.Barnaby,	BEAM Ltd,	10/3/05
 *******************************************************************************
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <iostream>

#include <TestcaseD.h>
#include <TestcaseS.h>
#include <TestcaseC.h>

class Service : public BoapServiceObject {
public:
			Service(BoapServer& server, BString name);
	BError		sendEvent1(BString eventName);
};

Service::Service(BoapServer& server, BString name): BoapServiceObject(server, name){
}

BError Service::sendEvent1(BString sigName){
	BError		err;
	BError		ret;
	BoapPacketHead	txhead;
	BoapPacket	tx;
	
	txhead.type = BoapTypeSignal;
	txhead.service = 0;
	txhead.cmd = 0;
	tx.pushHead(txhead);
	tx.push(oname);
	tx.push(sigName);
	printf("SendEvent1: Len: %d\n", tx.nbytes());
	if(err = sendEvent(tx))
		return err;

	return ret;
}

int main(int argc, char** argv){
	BoapServer		server;
	Service			service(server, "sig");
	BError			err;
	int			n;

	if(err = server.init()){
		std::cerr << err.getString() << "\n";
		return 1;
	}
	
	for(n = 0; n < 4; n++){
		err = service.sendEvent("test1", 22);
		printf("Result: %d %s\n", err.getErrorNo(), err.getString().retStr());
		sleep(2);
	}

#ifdef ZAP
	for(n = 0; n < 4; n++){
		err = service.sendEvent1("test1");
		printf("Result: %d %s\n", err.getErrorNo(), err.getString().retStr());
		sleep(2);
	}
#endif
	
	return 0;
}
