/*******************************************************************************
 *	BObject.cc	Beam Object
 *			T.Barnaby,	BEAM Ltd,	15/7/92
 *******************************************************************************
 */
#include	<stdio.h>
#include	<ctype.h>
#include	<memory.h>
#include	<string.h>
#include	<BObject.h>
#include	<iostream>

#define	DEBUG	0

BType BObject::otype = btypesList.appendType(BType("BObject", BTypeDomainBase, BTypeObject, createObj));

BType& BObject::getType(){
	return otype;
}

BObject* BObject::createObj(){
	return new BObject();
}


BObject::BObject(){
#if DEBUG
	printf("BObject(%p, %d)\n", this, type);
#endif
}

BObject::~BObject(){
}

BError BObject::getBinary(BDataBuf& buf) {
	buf.append(getType(), 0, 0);
	return BError();
}

BError BObject::setBinary(BDataBuf& buf){
	BType*	t;
	
	if(!buf.isEnd()){
		buf.nextType();
		buf.next();
	}
	return BError();
}

BMemberList BObject::getMemberList(){
	BMemberList	l;
	
	return l;
}

BError BObject::addMember(BString name, BObject* object){
	return BError(1, "Cannot add a member to this object");
}

BString BObject::getString() {
	return (BString)"";
}

BError BObject::setString(BString str){
	return BError();
}

void BObject::printIt(){
	BMemberList	l;
	BIter		i;

	std::cout << "Object: Type(" << getType().oname << ")\n";	
	l = getMemberList();
	for(l.start(i); !l.isEnd(i); l.next(i)){
		std::cout << "\tMember: " << l[i].getName() << " : " << l[i].getValue()->getString() << "\n";
	}
}
