/*******************************************************************************
 *	Gen.h		Generate output
 *			T.Barnaby,	BEAM Ltd,	12/9/03
 *******************************************************************************
 */
#ifndef GEN_HH
#define GEN_HH

#include <stdio.h>
#include <stdlib.h>
#include <BError.h>
#include <BDict.h>
#include <BFile.h>
#include <Node.h>
#include <Type.h>

class FileIndent : public BFile {
public:
		FileIndent();
	void	indentMore();
	void	indentLess();
	int	writeLine(BString line);
	int	printf(const char* fmt, ...);
private:
	int	oindent;
};

class StringIndent : public BString {
public:
		StringIndent();
	void	indentMore();
	void	indentLess();
	void	writeLine(BString line);
	void	printf(const char* fmt, ...);
private:
	int	oindent;
};

class Gen {
public:
			Gen();
	virtual		~Gen();
	virtual BError	produce(Node* n, BString fileName) = 0;
	
	// Utils
	BString		getTypeName(Node* n, int data = 0);
	BError		getTypeInfo(Node* n, BType& type, BTypeComp& typeMod, BUInt& size, BString& typeName);
	BString		getBaseClass(Node* node);
	int		isBaseType(Node* n);
	int		isRawType(Node* n);
	int		useCopyType(Node* n);
	void		setOptions(BDictString& options);
	int		setUseBObjects(int on);
	int		getUseBObjects();

protected:
	int		ouseBObjects;
	BDictString	ooptions;
};

#endif
