/*******************************************************************************
 *	TmsApi.h	Produced by Bidl
 *******************************************************************************
 */
#ifndef TmsApi_H
#define TmsApi_H 1

#include <BString.h>
#include <BList.h>
#include <BArray.h>
#include <TmsS.h>

using namespace Tms;

class Control;

class TmsControlServer : public Tms::TmsControlService {
public:
		TmsControlServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError setProcessPriority(BUInt32 priority);
	BError init();
	BError configure(ConfigInfo configInfo);
	BError getConfiguration(ConfigInfo& configInfo);
	BError setControlInfo(CycleParam params);
	BError getControlInfo(BString cycleType, BUInt32 ring, BUInt32 puChannel, CycleParam& params);
	BError delControlInfo(BString cycleType, BUInt32 ring, BUInt32 puChannel);
	BError getControlList(BList<CycleParamItem>& itemList);
	BError setNextCycle(BUInt32 cycleNumber, BString cycleType);
	BError test(BList<BError>& errors);
	BError getStatus(BList<NameValue>& statusList);
	BError getStatistics(BList<NameValue>& statsList);
	BError getPuChannel(BUInt32 puChannel, PuChannel& puPhysChannel);
	BError puServerStarted(BUInt32 number);
	BError setSimulation(Simulation simulation);
	BError getSimulation(Simulation& simulation);
	BError setTestMode(PuChannel puPhysChannel, BUInt32 testOutput, BUInt32 timingDisableMask);
	BError setTimingSignals(PuChannel puPhysChannel, BUInt32 timingSignals);
	BError captureDiagnostics(PuChannel puPhysChannel, TestCaptureInfo captureInfo, BArray<BUInt64>& data);
	BError setTestData(PuChannel puPhysChannel, BInt32 on, BArray<BUInt32> data);	///< This function will set a PU channel to sample data from memory rather than the ADC's
	BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig);
	BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig);
private:
	Control&	ocontrol;
};

class TmsProcessServer : public Tms::TmsProcessService {
public:
		TmsProcessServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError getCycleInfo(BUInt32& cycleNumber, BString& cycleType);
	BError getCycleInformation(BUInt32 cycleNumber, CycleInformation& cycleInformation);
	BError getCycleTypeInformation(BString cycleType, CycleTypeInformation& cycleTypeInformation);
	BError getData(DataInfo dataInfo, Data& data);

	BError addEventServer(BString name);
	BError requestData(DataInfo dataInfo);
private:
	Control&	ocontrol;
};

class TmsEventServer : public Tms::TmsEventService {
public:
		TmsEventServer(Control& control, BoapServer& server, BString name);
	BError errorEvent(BUInt32 cycleNumber, BError error);
	BError cycleStartEvent(BUInt32 cycleNumber);
	BError cycleStopEvent(BUInt32 cycleNumber);
	BError dataEvent(DataInfo dataInfo);
private:
	Control&	ocontrol;
};
#endif
