/*
* Title:	tmsControlMainWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	The main test Gui window
*
* Mod Rec:
*
*/

#ifndef	TMSCONTROLMAINWIN_H
#define TMSCONTROLMAINWIN_H	1


#include <AppGui.h>
#include <qtabwidget.h>
#include <BError.h>
#include <BString.h>
#include <Control.h>
#include <ConfigureWin.h>
#include <StatusWin.h>
#include <ControlDataWin.h>
#include <TestWin.h>
#include <StatisticsWin.h>
#include <OptionsWin.h>
#include <PupeDiagnosticsWin.h>
#include <PupeSimulateWin.h>
#include <PhaseTableWin.h>


class TmsControlMainWin: public AppGui {
	Q_OBJECT
public:
	TmsControlMainWin(Control& control);
	~TmsControlMainWin();

	void	configurationChanged();						///< Call when something has updated configuration.
	void	warningDialog(BString title,BError err,BString msg = "");	///< Warning dialog
public slots:
	void	slotQuit();				///< Exit the application
	void	slotNewConnection();			///< Create a new connection

private slots:
	void	slotEnterWhatsThis();			///< Enter Whats This mode
	void    slotPrefferences();			///< User wishes to configure setup	
	void	slotAbout();				///< Display the About dialog
	void	slotManual();				///< Display the online manual
	void	slotTmsManual();			///< Didplay Tms System Manual index
private:
	void	initMenubar();				///< Initialize menu bar
	void	initMain();				///< Initialize main widget
	void	initToolbar();				///< Initialize main widget
	
	ConfigureWin*		oconfigureWin;
	StatusWin*		ostatusWin;
	TestWin*		otestWin;
	ControlDataWin*		ocontrolDataWin;
	StatisticsWin*		ostatisticsWin;
	OptionsWin*		ooptionsWin;
	PupeDiagnosticsWin*	opupeDiagnosticsWin;
	PupeSimulateWin*	opupeSimulateWin;
	PhaseTableWin*		ophaseTableWin;
		
	QTabWidget*		otabd;			///< Tab widget controlling other widget panes
	Control&		ocontrol;
};
#endif
