/*******************************************************************************
 *	Config.cpp	Config File Access
 *			T.Barnaby,	BEAM Ltd,	30/10/02
 *******************************************************************************
 */
#include <Config.h>

int Config::open(BString filename){
	return BEntryFile::open(filename);
}

int Config::read(){
	int	r;
	
	olock.lock();
	r = BEntryFile::read();
	olock.unlock();
	return r;
}

int Config::write(){
	int	r;
	
	olock.lock();
	r = BEntryFile::write();
	olock.unlock();
	return r;
}

BString Config::findValue(BString name){
	BString	v;
	
	olock.lock();
	v = BEntryFile::findValue(name);
	olock.unlock();
	return v;
}

int Config::setValue(BString name, BString value){
	int	r;
	
	olock.lock();
	r = BEntryFile::setValue(name, value);
	olock.unlock();
	return r;
}
