/*******************************************************************************
 *	Debug.h		Debug information and routines
 *			T.Barnaby,	BEAM Ltd,	2007-02-07
 *******************************************************************************
 */
#ifndef Debug_H
#define	Debug_H

#ifndef ZAP
// New uses BDebug.h
#undef wprintf
#include <BDebug.h>
#include <stdint.h>

#define	DBG_STD			0x000001
#define DBG_CMD			0x000002
#define DBG_EVENT		0x000004
#define DBG_SETNEXTCYCLE	0x000020
#define DBG_RESOURCE		0x000100
#define	DBG_THREADS		0x001000
#define	DBG_MISC		0x010000

#else
// Old pre BDebug.h
#include <stdio.h>
#include <wchar.h>
#include <syslog.h>
#include <time.h>

#define	DBG_STD			0x000001
#define DBG_CMD			0x000002
#define DBG_EVENT		0x000004
#define DBG_SETNEXTCYCLE	0x000020
#define DBG_RESOURCE		0x000100
#define	DBG_THREADS		0x001000
#define	DBG_MISC		0x010000

extern int	bdebug;

void hd8(void* data, int n);
void hd32(void* data, int n);
double getTime();
void setDebug(int debug);
void tprintf(int log, const char* fmt, ...);
void tfprintf(const char* fmt, ...);

pid_t gettid();

/// General debug functions
#if DEBUG
#define	dprintf(level, fmt, a...)       if((level) & bdebug) tprintf(1, fmt, ##a);
#else
#define	dprintf(level, fmt, a...)
#endif

/// Warnings and errors logging
#if DEBUG
#define	nprintf(fmt, a...)	{ syslog(LOG_NOTICE, fmt, ##a); if(DBG_STD & bdebug) tprintf(0, fmt, ##a); }
#define	wprintf(fmt, a...)	{ syslog(LOG_WARNING, fmt, ##a); if(DBG_STD & bdebug) tprintf(0, fmt, ##a); }
#define	eprintf(fmt, a...)	{ syslog(LOG_ERR, fmt, ##a); if(DBG_STD & bdebug) tprintf(0, fmt, ##a); }
#else
#define	nprintf(fmt, a...)	syslog(LOG_NOTICE, fmt, ##a)
#define	wprintf(fmt, a...)	syslog(LOG_WARNING, fmt, ##a)
#define	eprintf(fmt, a...)	syslog(LOG_ERR, fmt, ##a)
#endif

/// Debug file
#if DEBUG
#define	dfprintf(fmt, a...)       tfprintf(fmt, ##a);
#else
#define	dfprintf(fmt, a...)
#endif

#endif
#endif
