/*
* Title:	BQComboBox.cpp
* Author:	M.Thomas BEAM Ltd
* Date:		2005-10-27
*
* Contents:	Qt combo box that can be setup from a struct. Additionally support a signal
*		passing the object.
*/


#include <BQComboBox.h>


BQComboBox::BQComboBox(QWidget* parent, const char* name, WFlags fl) : QComboBox(parent,name) {
	oid = 0;
	connect(this,SIGNAL(activated(int)),this, SLOT(activated(int)));
};

BQComboBox::BQComboBox(ComboDefinition* comboDef,QWidget* parent, const char* name, WFlags fl) : QComboBox(parent,name) {
	oid = 0;
	connect(this,SIGNAL(activated(int)),this, SLOT(activated(int)));
	initWithDefinition(comboDef);
};


BQComboBox::~BQComboBox() {}


void BQComboBox::setId(int id) {
	oid = id;
}

void BQComboBox::initWithDefinition(ComboDefinition* comboDef) {
	ComboDefinition*	d = comboDef;
	
	odefinition = comboDef;

	while (d->label != 0) {
		insertItem(d->label);
		d++;
	}
	d = comboDef;
	while (d->label != 0) {
		if (d->isDefault) {
			setCurrentItem(d->index);
			break;
		}	
		d++;
	}
}

void	BQComboBox::setValue(double val) {
	ComboDefinition* 	d = odefinition;

	while (d->label != 0) {
		if ( val == d->value) {
			setCurrentItem(d->index);
			break;
		}	
		d++;
	}
}



double	BQComboBox::getDefault() {
	ComboDefinition* 	d = odefinition;
	double			ret = d->value;
	
	while (d->label != 0) {
		if (d->isDefault) {
			return d->value;
		}
		d++;
	}
	return ret;
}


double	BQComboBox::getValue() {
	ComboDefinition* 	d = odefinition;

	while (d->index != currentItem() && (d->label != 0)) {
		d++;
	}
	if ( d->label == 0x00)
		return 0x00;
	return d->value;
}

void BQComboBox::activated(int val) {
	emit activated(this,oid,val);
}
