/*******************************************************************************
 *	BEvent.h	File Event class
 *			T.Barnaby,	BEAM Ltd,	2005-07-08
 *******************************************************************************
 */
#ifndef BEvent_H
#define BEvent_H	1

#include <stdint.h>
#include <BError.h>

enum BEventType { BEventTypeNone, BEventTypeInt, BEventTypeError };

/// \brief This class provides a base class for all event objects that can
/// be sent over the events interface.
class BEvent {
public:
			BEvent(uint32_t type);
	virtual		~BEvent();
	
	uint32_t	getType();

			// Implementation functions
	virtual BError	getBinary(void* data, uint32_t& size);
	virtual BError	setBinary(void* data, uint32_t& size);
private:
	uint32_t	otype;			///< The event type
};

class BEventError : public BError, public BEvent {
public:
			BEventError(int errNo = NONE, BString errStr = "");
	BError		getBinary(void* data, uint32_t& size);
	BError		setBinary(void* data, uint32_t& size);
private:
};

/// \brief This class provides a base interface for sending events
/// via a pipe. This allows threads to send events that can be
/// picked up by the poll system call.
class BEventPipe {
public:
			BEventPipe();
			~BEventPipe();
			
	BError		sendEvent(BEvent* event);	///< Send an event
	BError		getEvent(BEvent* event, int timeOutUs = -1);	///< Receive the event
	
	int		getReceiveFd();			///< returns the receive file descriptor for the poll system call
private:
	int		ofds[2];			///< File descriptors for pipe
};


/// \brief This class provides an interface for sending simple integer events
/// via a file descriptor. This allows threads to send events that can be
/// picked up by the poll system call.
class BEventInt {
public:
			BEventInt();
			~BEventInt();
			
	BError		sendEvent(int event);		///< Send an event
	BError		getEvent(int& event, int timeOutUs = -1);	///< Receive the event.
	
	int		getFd();
private:
	int		ofds[2];			///< File descriptors for pipe
};

#endif
