#include <stdio.h>
#include <TmsLib.h>

void printCycleParams(Tms::CycleParam p){
	unsigned int	i;
	unsigned int	s;

	printf("cycleNumber:\t%d\n", p.cycleNumber);
	printf("cycleType:\t%d\n", p.cycleType);
	printf("pllInitialFrequency:\t%d\n", p.pllInitialFrequency);
	printf("pllInitialFrequencyDelay:\t%d\n", p.pllInitialFrequencyDelay);
	printf("pllGain:\t%d\n", p.pllGain);
	printf("pllDdsMinimum:\t%d\n", p.pllDdsMinimum);
	printf("pllDdsMaximum:\t%d\n", p.pllDdsMaximum);
	
	printf("frefPhaseDelaySize:\t%d\n", p.frefPhaseDelay.size());
	for(i = 0; (i < p.frefPhaseDelay.size()) && (i < 8); i++){
		printf("frefPhaseDelay[%d]:\t%d\n", i, p.frefPhaseDelay[i]);
	}
	
	printf("stateTableSize:\t%d\n", p.stateTable.size());
	for(s = 0; s < p.stateTable.size(); s++){
		printf("stateTable[%d].state:\t0x%x\n", s, p.stateTable[s].state);
		printf("stateTable[%d].numBunches:\t%d\n", s, p.stateTable[s].numBunches);
		printf("stateTable[%d].phaseTableSize:\t%d\n", s, p.stateTable[s].phaseTable.size());
		for(i = 0; (i < p.stateTable[s].phaseTable.size()) && (i < 8); i++){
			printf("stateTable[%d].phaseTable[%d]:\t%x\n", s, i, p.stateTable[s].phaseTable[i]);
		}
	}
}

int main(){
	BError		err;
	BList<BString>	l;
	BIter		i;
	TmsCycleParams	c;
	Tms::CycleParam p;
	
	if(err = c.getCycleTypes(l)){
		printf("Error getting Cycle Types: %s\n", err.getString().retStr());
		return 1;
	}

	for(l.start(i); !l.isEnd(i); l.next(i)){
		printf("Type: %s\n", l[i].retStr());
	}
	
	if(err = c.getCycleParams(l.front(), p)){
		printf("Error getting Cycle Type: %s\n", err.getString().retStr());
		return 1;
	}
	printCycleParams(p);

	return 0;
}
