/*******************************************************************************
 *	Server.cc	HomeNet RPC protocol test server
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <BString.h>
#include <Test1S.h>

void hd(void* data, int nb){
	unsigned char*	p = (unsigned char*)data;
	int		n = 0;
	
	while(n < nb){
		printf("%2.2x ", *p++);
		n++;
		if((n & 0xF) == 0)
			printf("\n");
	}
}

class Server : public HomeNet::Test1Server {
public:
	Int32 getStatus(Int32 a1, Int32 a2);
	Int32 sendGetList(BList<HomeNet::DataA> a1, BList<HomeNet::DataA>& a2);
	Int32 getInfo(Int32 a1, HomeNet::DataB a2, Int32& a3, HomeNet::DataB& a4);
	BError getVersion(BString& version);
};

Int32 Server::getStatus(Int32 a1, Int32 a2){
	printf("Server::getStatus\n");
	return 44;
}

Int32 Server::sendGetList(BList<HomeNet::DataA> a1, BList<HomeNet::DataA>& a2){
	BIter	i;
	
	printf("Server::sendGetList: Len: %d\n", a1.number());
	for(a1.start(i); !a1.isEnd(i); a1.next(i)){
		a2.append(a1[i]);
	}
	return 33;
}

Int32 Server::getInfo(Int32 a1, HomeNet::DataB a2, Int32& a3, HomeNet::DataB& a4){
	printf("Server::getInfo\n");
	return 55;
}

BError Server::getVersion(BString& version){
	BError	err;
	
	printf("Server::getVersion\n");
	return err;
}


#ifdef ZAP
BError TestServer::doSendString(HomeNetPacket& rx, HomeNetPacket& tx){
	BError			err;
	HomeNetPacketHead	rxhead;
	HomeNetPacketHead	txhead;
	BString			s;

	rx.popHead(rxhead);
	rx.pop(s);
	
	sendString(s);
	
	txhead.cmd = rxhead.cmd;
	tx.pushHead(txhead);
	return err;
}

BError TestServer::sendString(BString s){
	BError			err;

	cout << "Server got string: " << s << "\n";
	return err;
}
#endif

int main(int argc, char** argv){
	BNetAddress		nadd("", 11000);
	Server			server;
	BError			err;
	int			r;
	int			fd;

	printf("Server1\n");	
	if(err = server.bind(nadd)){
		cerr << strerror(errno) << "\n";
		return 1;
	}

	server.listen();
	printf("Server2\n");
	fd = server.accept();
	printf("Server3\n");
	err = server.process(fd);
	printf("Server4: %d %s\n", err.getErrorNo(), err.getString().retStr());
	
	return 0;
}
