/***************************************************************************
 *	TmsControlGui.cpp	Main program
 *			T.Barnaby,	BEAM Ltd,	2007-02-13
 ***************************************************************************
 */
#include <Gui.h>
#include <stdio.h>
#include <BError.h>
#include <getopt.h>
#include <iostream>
#include <Config.h>
#include <Debug.h>
#include <Globals.h>

using namespace std;


static struct option options[] = {
		{ "?",			0, NULL, 0 },
		{ "h",			0, NULL, 0 },
		{ "help",		0, NULL, 0 },
		{ "debug",		1, NULL, 0 },
		{ "version",		0, NULL, 0 },
		{ "r",			1, NULL, 0 },
		{ 0,0,0,0 }
};

void usage(void) {
	cerr << "Usage:\ttmsControlGui [options] [hostname]\n";
	cerr << "\t-r <n>             - Connect to given rings server\n";
	cerr << "\t--help             - Help on command line parameters\n";
	cerr << "\t--debug 0xXXXX     - Set Debug bit mask\n";
	cerr << "\t                     0x0001 - Standard\n";
	cerr << "\t                     0x0002 - Debug server connection\n";
	cerr << "\t--version          - Display Version numbers\n";
	cerr << "\n";
}

int main(int argc, char** argv){
	BError		err;
	Control*	control;
	Gui*		gui;
	BString		s;
	int		c;
	int		optIndex = 0;
	bool		version =0;

	ghostName = "localhost";
	gring = 1;
	
	while((c = getopt_long_only(argc, argv, "", options, &optIndex)) == 0){
		s = options[optIndex].name;
		if(s == "help" || s == "h" || s == "?"){
			usage();
			return 1;
		}
		else if(s == "debug"){
			gdebug = strtol(optarg, 0, 0);
		}
		else if(s == "version"){
			version = 1;
		}
		else if(s == "r"){
			gring = strtol(optarg, 0, 0);
		}
	}
	if(optind < argc){
		ghostName = argv[optind];
	}
       // Open and read configuration
        if(gconfig.open("tmsControlGuiDebug.conf"))
                if(gconfig.open("tmsControlGui.conf"))
                        gconfig.open("/etc/tmsControlGui.conf");
       gconfig.read();

	if (version) {
		cout << "Version: " << VERSION << "\n";
		return 0;
	}
	control = new Control();
	
	// Create Gui control class
	gui = new Gui(*control);
	if(err = gui->init(argc, argv)){
		printf("Error: %s\n", err.getString().retStr());
		return 1;
	}
	gui->run();
	return 0;
}
