-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_rd_data_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : The delay between the read data with respect to the command 
-- 			   issued is calculted in terms of no. of clocks. This data is 
-- 			   then stored into the FIFOs and then read back and given as 
--			   the ouput for comparison.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;

--
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

 
 entity mem_interface_small_rd_data_0 is
port (
      CLK                   : in std_logic;
      RESET                 : in std_logic;
      CTRL_RDEN             : in std_logic;
      READ_DATA_RISE        : in std_logic_vector(data_width-1 downto 0);
      READ_DATA_FALL        : in std_logic_vector(data_width-1 downto 0);
      READ_DATA_FIFO_RISE   : out std_logic_vector(data_width-1 downto 0);
      READ_DATA_FIFO_FALL   : out std_logic_vector(data_width-1 downto 0);
      READ_DATA_VALID       : out std_logic;
      COMP_DONE             : out std_logic;
      TEST_BUS              : out std_logic_vector(3 downto 0)
     );
end entity;



architecture arc_rd_data of mem_interface_small_rd_data_0 is

component mem_interface_small_rd_data_fifo_0
port (
      CLK                   : in std_logic;
      RESET                 : in std_logic;
      FIFO_RD_EN            : in std_logic;
      READ_EN_DELAYED_RISE  : in std_logic;
      READ_EN_DELAYED_FALL  : in std_logic;
      FIRST_RISING          : in std_logic;
      READ_DATA_RISE        : in std_logic_vector(memory_width-1 downto 0);
      READ_DATA_FALL        : in std_logic_vector(memory_width-1 downto 0);
      READ_DATA_FIFO_RISE   : out std_logic_vector(memory_width-1 downto 0);
      READ_DATA_FIFO_FALL   : out std_logic_vector(memory_width-1 downto 0);
      READ_DATA_VALID       : out std_logic
      );
end component;

component mem_interface_small_pattern_compare4  
   port(      clk            : in std_logic ;
	      rst            : in std_logic ;
	      ctrl_rden      : in std_logic ;
	      rd_data_rise   : in std_logic_vector(3 downto 0) ;	
	      rd_data_fall   : in std_logic_vector(3 downto 0) ;		
	      comp_done      : out std_logic;	
	      first_rising   : out std_logic;
	      rd_en_rise     : out std_logic;	
	      rd_en_fall     : out std_logic
	     );
end component ;
component mem_interface_small_pattern_compare8  
   port(      clk            : in std_logic ;
	      rst            : in std_logic ;
	      ctrl_rden      : in std_logic ;
	      rd_data_rise   : in std_logic_vector(7 downto 0) ;	
	      rd_data_fall   : in std_logic_vector(7 downto 0) ;		
	      comp_done      : out std_logic;	
	      first_rising   : out std_logic;
	      rd_en_rise     : out std_logic;	
	      rd_en_fall     : out std_logic
	     );
end component ;



 signal read_data_valid0 :  std_logic;
 signal read_data_valid1 :  std_logic;
 signal read_data_valid2 :  std_logic;
 signal read_data_valid3 :  std_logic; 

signal COMP_DONE_int       : std_logic_vector(ReadEnable-1 downto 0);
signal FIRST_RISING_int    : std_logic_vector(ReadEnable-1 downto 0);

signal READ_EN_DELAYED_RISE  : std_logic_vector(ReadEnable-1 downto 0);
signal READ_EN_DELAYED_FALL  : std_logic_vector(ReadEnable-1 downto 0);
signal fifo_read_enable_r  : std_logic;
signal fifo_read_enable_2r : std_logic;

begin

READ_DATA_VALID <= read_data_valid0; 

COMP_DONE <=  COMP_DONE_int(0)  ;


 process(CLK)
   begin
     if (CLK'event and CLK = '1') then 
        if (RESET = '1') then      
           fifo_read_enable_r   <= '0';
           fifo_read_enable_2r  <= '0';
        else
           fifo_read_enable_r   <= READ_EN_DELAYED_RISE(0);
           fifo_read_enable_2r   <= fifo_read_enable_r;
        end if;
    end if;
end process;

TEST_BUS <= READ_EN_DELAYED_RISE(0) & READ_EN_DELAYED_FALL(0) & fifo_read_enable_2r & read_data_valid0;

  pattern_0 : mem_interface_small_pattern_compare8
    port map( clk          => CLK,
          rst          => RESET,
          ctrl_rden    => CTRL_RDEN,
          rd_data_rise => READ_DATA_RISE(31  downto  24),
          rd_data_fall => READ_DATA_FALL(31  downto  24),
          comp_done    => COMP_DONE_int(0),
          first_rising => FIRST_RISING_int(0),
          rd_en_rise   => READ_EN_DELAYED_RISE(0),
          rd_en_fall   => READ_EN_DELAYED_FALL(0)
        );


rd_data_fifo0 : mem_interface_small_rd_data_fifo_0
    port map    (
                      CLK                  => CLK,
                      RESET                => RESET,
                      FIFO_RD_EN           => fifo_read_enable_2r,
                      READ_EN_DELAYED_RISE => READ_EN_DELAYED_RISE(0),
                      READ_EN_DELAYED_FALL => READ_EN_DELAYED_FALL(0),
                      FIRST_RISING         => FIRST_RISING_int(0),
                      READ_DATA_RISE       => READ_DATA_RISE(7 downto 0),
                      READ_DATA_FALL       => READ_DATA_FALL(7 downto 0),
                      READ_DATA_FIFO_RISE  => READ_DATA_FIFO_RISE(7 downto 0),
                      READ_DATA_FIFO_FALL  => READ_DATA_FIFO_FALL(7 downto 0),
                      READ_DATA_VALID      => read_data_valid0
                  );


rd_data_fifo1 : mem_interface_small_rd_data_fifo_0
    port map    (
                      CLK                  => CLK,
                      RESET                => RESET,
                      FIFO_RD_EN           => fifo_read_enable_2r,
                      READ_EN_DELAYED_RISE => READ_EN_DELAYED_RISE(0),
                      READ_EN_DELAYED_FALL => READ_EN_DELAYED_FALL(0),
                      FIRST_RISING         => FIRST_RISING_int(0),
                      READ_DATA_RISE       => READ_DATA_RISE(15 downto 8),
                      READ_DATA_FALL       => READ_DATA_FALL(15 downto 8),
                      READ_DATA_FIFO_RISE  => READ_DATA_FIFO_RISE(15 downto 8),
                      READ_DATA_FIFO_FALL  => READ_DATA_FIFO_FALL(15 downto 8),
                      READ_DATA_VALID      => read_data_valid1
                  );


rd_data_fifo2 : mem_interface_small_rd_data_fifo_0
    port map    (
                      CLK                  => CLK,
                      RESET                => RESET,
                      FIFO_RD_EN           => fifo_read_enable_2r,
                      READ_EN_DELAYED_RISE => READ_EN_DELAYED_RISE(0),
                      READ_EN_DELAYED_FALL => READ_EN_DELAYED_FALL(0),
                      FIRST_RISING         => FIRST_RISING_int(0),
                      READ_DATA_RISE       => READ_DATA_RISE(23 downto 16),
                      READ_DATA_FALL       => READ_DATA_FALL(23 downto 16),
                      READ_DATA_FIFO_RISE  => READ_DATA_FIFO_RISE(23 downto 16),
                      READ_DATA_FIFO_FALL  => READ_DATA_FIFO_FALL(23 downto 16),
                      READ_DATA_VALID      => read_data_valid2
                  );


rd_data_fifo3 : mem_interface_small_rd_data_fifo_0
    port map    (
                      CLK                  => CLK,
                      RESET                => RESET,
                      FIFO_RD_EN           => fifo_read_enable_2r,
                      READ_EN_DELAYED_RISE => READ_EN_DELAYED_RISE(0),
                      READ_EN_DELAYED_FALL => READ_EN_DELAYED_FALL(0),
                      FIRST_RISING         => FIRST_RISING_int(0),
                      READ_DATA_RISE       => READ_DATA_RISE(31 downto 24),
                      READ_DATA_FALL       => READ_DATA_FALL(31 downto 24),
                      READ_DATA_FIFO_RISE  => READ_DATA_FIFO_RISE(31 downto 24),
                      READ_DATA_FIFO_FALL  => READ_DATA_FIFO_FALL(31 downto 24),
                      READ_DATA_VALID      => read_data_valid3
                  );


   

end arc_rd_data;
