/*******************************************************************************
 *	BDebug.cpp	BEAM Debug classes
 *			T.Barnaby,	BEAM Ltd,	23/6/04
 *******************************************************************************
 */
#include <BDebug.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <time.h>
#include <execinfo.h>

#define	BTRACE_SIZE	200

const unsigned int	STRBUF_SIZE	= (64 * 1024);

BDebugBacktrace::BDebugBacktrace(){
}

BDebugBacktrace::~BDebugBacktrace(){
}

void BDebugBacktrace::dumpBacktrace(char* strBuf, int strBufLen, char* comment){
	void*	bt[BTRACE_SIZE];
	int	btn;
	char**	p;
	int	n;

	if(comment)
		strcpy(strBuf, comment);
	else
		strcpy(strBuf, "");
	
	btn = backtrace(bt, BTRACE_SIZE);
	p = backtrace_symbols(bt, btn);
	
	for(n = 0 ; n < btn; n++){
		strcat(strBuf, p[n]);
		strcat(strBuf, "\n");
	}
}

void BDebugBacktrace::dumpBacktraceStdout(char* comment){
	char	strBuf[STRBUF_SIZE];

	dumpBacktrace(strBuf, sizeof(strBuf), comment);
	
	write(1, strBuf, strlen(strBuf));
}

int BDebugBacktrace::dumpBacktraceFile(char* fileName, char* comment){
	int	fd;
	char	strBuf[STRBUF_SIZE];

	if((fd = open(fileName, O_CREAT | O_RDWR | O_APPEND, 0666)) < 0){
		return fd;
	}

	dumpBacktrace(strBuf, sizeof(strBuf), comment);
	
	write(fd, strBuf, strlen(strBuf));
	close(fd);

	return 0;
}

void BDebugBacktrace::dumpBacktraceSyslog(char* comment){
	char	strBuf[STRBUF_SIZE];

	dumpBacktrace(strBuf, sizeof(strBuf), comment);
	
	syslog(LOG_ERR, "%s", strBuf);
}
