/*******************************************************************************
 *	BNameValue.h	Beam Name Vlaue Object
 *			T.Barnaby,	BEAM Ltd,	16/8/00
 *******************************************************************************
 */
#ifndef BNAMEVALUE_H
#define BNAMEVALUE_H	1

#include	<BList.h>
#include	<BString.h>

#define TEMPLATE_NEW	1

template <class T> class BNameValue {
public:
			BNameValue(){
			}
			BNameValue(BString name, const T& value){
				oname = name;
				ovalue = value;
			}

	BString		getName(){	return oname; }
	T&		getValue(){ return ovalue; }
private:
	BString		oname;
	T		ovalue;
};

template <class T> class BNameValueList : public BList< BNameValue<T> > {
public:
#if TEMPLATE_NEW
	T*		find(BString name){
				for(BIter i = this->begin(); !this->isEnd(i); this->next(i)){
					if(this->get(i).getName() == name)
						return &this->get(i).getValue();
				}
				return 0;
			}
#else
	T*		find(BString name){
				for(BIter i = begin(); !isEnd(i); next(i)){
					if(get(i).getName() == name)
						return &get(i).getValue();
				}
				return 0;
			}
#endif
};

#endif
