/*******************************************************************************
 *	Type.h		C Type Object
 *			T.Barnaby,	BEAM Ltd,	20/2/02
 *******************************************************************************
 */
#ifndef	TYPE_HH
#define	TYPE_HH

#include <stdio.h>
#include <BList.h>
#include <BString.h>
#include <Node.h>

/*
 *	The actual Ctype
 */
class Type {
public:
			// Create Major type
			Type(BString typeName, Node* node, Type* derived = 0);
			~Type();

	BString		name();
	int		size();
	Node*		node();
	Type*		derived();

	void		print();
private:
	BString		otypeName;
	Node*		onode;
	Type*		oderived;
};

class TypeList : public BList<Type>
{
public:
	Type*	search(BString name) {
			BIter	i;
			
			for(start(i); !isEnd(i); next(i)){
				if(get(i).name() == name)
					return &get(i);
			}
			return 0;
		}
	void	print(){
			BIter	i;

			fprintf(stdout, "Types: \n");
			for (start(i); !isEnd(i); next(i)){
				get(i).print();
			}
		}
};
#endif
