/*******************************************************************************
 *	BSema.h		BSema Classes
 *			T.Barnaby,	BEAM Ltd,	6/11/02
 *******************************************************************************
 */
#ifndef BSEMA_H
#define BSEMA_H	1

#include <semaphore.h>

/// Sempahore class
class BSema {
public:
			BSema(int value = 0);
			BSema(const BSema& sema);
			~BSema();
	
	int		post();				///< Post condition
	int		wait();				///< Wait for contition
	int		timedWait(int timeUs);		///< Wait for condition with timeout
	int		tryWait();			///< Test for the condition
	int		getValue() const;
	
	BSema&		operator=(const BSema& sema);
private:
	sem_t		osema;
};

#endif
