/*******************************************************************************
 *	Client.cc	HomeNet RPC protocol test client
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <BString.h>
#include <TestD.h>
#include <TestC.h>

double getTime()
{
    struct timeval	tp;

    gettimeofday(&tp, NULL);
    return ((double) tp.tv_sec + (double) tp.tv_usec * 1e-6);
}

void test1(Test::Obj1& client){
	BError		err;
	double		ts, te;
	int		n;
	int		num = 1000;
	Int32		a1 = 33;
	Test::Data	a2;
	double		r;
	
	ts = getTime();
	for(n = 0; n < num; n++){
		err = client.setData(a1);
	}
	te = getTime();
	
	r = num / (te - ts);
	printf("Test1: %f Calls per sec %fms per call\n", r, 1000/r);
}

void test2(Test::Obj1& client){
	BError		err;
	double		ts, te;
	int		n;
	int		num = 1000;
	Int32		a1 = 33;
	Test::Data	a2;
	double		r;
	
	ts = getTime();
	for(n = 0; n < num; n++){
		err = client.getData(a1);
	}
	te = getTime();
	
	r = num / (te - ts);
	printf("Test2: %f Calls per sec %fms per call\n", r, 1000/r);
}

void test3(Test::Obj1& client){
	BError		err;
	double		ts, te;
	int		n;
	int		num = 10;
	Int32		a1 = 33;
	Test::Data	a2;
	double		r;
	
	a2.num = 1024*1024;
	a2.data.resize(1024*1024);
	
	ts = getTime();
	for(n = 0; n < num; n++){
		err = client.setData1(a1, a2);
	}
	te = getTime();
	
	r = num / (te - ts);
	printf("Test3: %f Calls per sec %fms per call\n", r, 1000/r);
	r = (num * a2.num * sizeof(Test::DataValue)) / (te - ts);
	printf("Test3: %f MBytes/sec\n", r / (1024*1024));
}

void test4(Test::Obj1& client){
	BError		err;
	double		ts, te;
	int		n;
	int		num = 10;
	Int32		a1 = 33;
	Test::Data	a2;
	double		r;
	
	ts = getTime();
	for(n = 0; n < num; n++){
		err = client.getData1(a1, a2);
	}
	te = getTime();
	
	r = num / (te - ts);
	printf("Test4: %f Calls per sec %fms per call\n", r, 1000/r);
	r = (num * a2.num * sizeof(Test::DataValue)) / (te - ts);
	printf("Test4: %f MBytes/sec\n", r / (1024*1024));
}

void test5(Test::Obj1& client){
	BError		err;
	double		ts, te;
	int		n;
	int		num = 10;
	Int32		a1 = 33;
	Test::Data	a2;
	double		r;

	client.setConnectionPriority(BoapPriorityHigh);

	a2.num = 1024*1024;
	a2.data.resize(1024*1024);
	err = client.setData1(a1, a2);
	
	ts = getTime();
	for(n = 0; n < num; n++){
		err = client.setData1(a1, a2);
	}
	te = getTime();
	
	r = num / (te - ts);
	printf("Test5: %f Calls per sec %fms per call\n", r, 1000/r);
	r = (num * a2.num * sizeof(Test::DataValue)) / (te - ts);
	printf("Test5: %f MBytes/sec\n", r / (1024*1024));
}

int main(int argc, char** argv){
//	Test::Obj1	client("test");
//	Test::Obj1	client("//localhost/test");
	Test::Obj1	client("//beam/test");
	BError		err;

	test1(client);
	test2(client);
	test3(client);
	test4(client);
	test5(client);
	
	return 0;
}
