/*
* Title:	ControlDataWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	User interface enabling the access of data from the TMS server
*
* Mod Rec:
*
*/

#ifndef CONTROLDATAWIN_H
#define CONTROLDATAWIN_H

#include <BString.h>
#include <qhbox.h>
#include <Control.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <BQComboBox.h>
#include <TmsLib.h>
#include <qtimer.h>
#include <qscrollbar.h>
#include <BGraph.h>
#include <BGraphControls.h>

/*! Configure System and setup user interface window. 
*
*/
class ControlDataWin : public QHBox {
        Q_OBJECT
public:
        ControlDataWin(QWidget* w,Control& c);
	~ControlDataWin();

public slots:
	void	show();					///< Update and make the widget visible
	void	hide();
private slots:
	void	refresh();
	void 	plot();
	void 	setPlotData();
	void	saveFile();
	void	updateStatus();	
	void	updateAutoCycle();	
	void	updateAllChannels();	
private:
	void	printDataInfo();
	void	warningDialog(BString title, BError err);
	bool 	eventFilter( QObject *o, QEvent *e );

	Control&		ocontrol;

	QTimer*			oticker;

	Tms::DataInfo		odataInfo;
	Tms::Data		odata;

	BGraph*			oplotSigma;
	BGraph*			oplotDeltaX;
	BGraph*			oplotDeltaY;
	BGraphControlBasic*	ographControls;
	
	BArray<float>		osigma;
	BArray<float>		odeltaX;
	BArray<float>		odeltaY;

	QLabel*			ocurrentCycle;
	
	BQComboBox*		ocyclePeriod;
	BQComboBox*		ofunction;
	BQComboBox*		obunchNumber;

	QLineEdit*		ocycleNumber;
	QCheckBox*		oautoCycleNumber;
	QCheckBox*		osaveFile;

	QCheckBox*		oallChannels;
	QSpinBox*		ochannel;
	QLineEdit*		ostartTime;
	QLineEdit*		oorbitNumber;
	QLineEdit*		oargument;
	QCheckBox*		obeyondPeriod;
	QLineEdit*		onumValues;
};
#endif
