/*******************************************************************************
 *	BEntry.hh	Database entry system
 *			T.Barnaby,	BEAM Ltd,	10/5/93
 *******************************************************************************
 */
#ifndef BENTRY_H
#define BENTRY_H

#include <BList.h>
#include <BString.h>

/// Manipulate a name value pair
class BEntry {
public:
			BEntry();
			BEntry(BString name, BString value);	///< Set name and value
			BEntry(BString line);			///< Set name and value from white space deliminated string
	BString		getName();				///< Get the name
	BString		getValue();				///< Get the value
	void		setLine(BString line);			///< Set name and value from white space deliminated string
	void		setName(BString name);			///< Set the name
	void		setValue(BString value);		///< Set the value
	BString		line();					///< Return name and value as padded single string
	void		print();				///< Print name and value
private:
	BString		oname;
	BString		ovalue;
};


/// List of Entries. Where an entry is a name value pair
class BEntryList : public BList<BEntry> {
public:
			BEntryList();
	int		isSet(BString name);			///< 1 if name is in list and value is set
	BEntry*		find(BString name);			///< Returns entry if name is found otherwise NULL
	BString		findValue(BString name);		///< Returns value of name. Returns "" if name not found
	int		setValue(BString name, BString value);	///< Set the value of name. Returns 0 if name not found
	int		setValueRaw(BString name, BString value);	///< Raw setting of value without looking up existing entry
	void		deleteEntry(BString name);		///< Deletes the entry
	
	void		print();				///< Print list
	BString		getString();				///< Return list as string. Each Entry padded and on a new line

			// Override these functions as we cache olastPos
	void		insert(BIter& i, const BEntry& item);
	void		del(BIter& i);
	void		clear();
private:
	BIter		olastPos;	// Last position speed up
};

/// File of Entries. 
class BEntryFile : public BEntryList {
public:
			BEntryFile();
			BEntryFile(BString filename);		///< Opens entryfile
			~BEntryFile();

	int		open(BString filename);			///< Opens entryfile
	int		read();					///< Reads entry file and builds list
	int		write();				///< Writes list to entryfile
	int		writeList(BEntryList& l);		///< Writes specified list to file
	void		clear();				///< Clears current list
private:
	BString		ofilename;
	BString		ocomments;
};
#endif
