/*
* Title:	PupeDiagnosticsWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Pupe Diagnostics window
*
* Mod Rec:
*
* Added	state dependent	trigger	controls - 2011-07-20 Jeroen Belleman (JMB)
*/


#ifndef PUPEDIAGNOSTICSWIN_H
#define PUPEDIAGNOSTICSWIN_H

#include <BString.h>
#include <Control.h>
#include <TmsLib.h>
#include <CurveInfo.h>
#include <BQComboBox.h>
#include <qhbox.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <BGraph.h>
#include <BGraphControls.h>
#include <BFile.h>



typedef	struct {
	char*	name;
	int	startBit;
	int	nBits;
	bool	isSigned;
	double	gain;
} PupeDiagBitDefinition;




/*! Configure System and setup user interface window. 
*
*/
class PupeDiagnosticsWin : public QHBox {
        Q_OBJECT
public:
        PupeDiagnosticsWin(QWidget* w,Control& c);
	~PupeDiagnosticsWin();
public slots:
	void	show();					///< Update and make the widget visible
private slots:
	void	refresh();
	void	saveFile();
	void	statebuttonupdate(); //JMB
private:
	void	setXAxisLabel();	
	void	setGraphHeights(int numGraphs);
	void 	setPlotData();
	void	updateGraphs(PupeDiagBitDefinition defs[]);
	
	bool 	eventFilter(QObject *o, QEvent *e );
	void	warningDialog(BString title, BError err);

	void	writeFile(PupeDiagBitDefinition defs[]);
	BArray<float> extractBitLinear(PupeDiagBitDefinition def);
	void	doFft();
	
	Control&		ocontrol;

	BArray< UInt64 >	odata;

	BList<BGraph*>	oplots;
	
	QSpinBox*	ochannel;
	BQComboBox*	osource;
	BQComboBox*	oclock;

	QCheckBox*	otriggerSourceData;
	QCheckBox*	otriggerAnd;
	QCheckBox*	otriggerStore;
	QCheckBox*	okst;
	
	QLineEdit*	ostartTime;
	QLineEdit*	opostTriggerDelay;
	QLineEdit*	otriggerMask;

	QCheckBox*	oClock;
	QCheckBox*	oCycleStart;
	QCheckBox*	oCycleStop;
	QCheckBox*	oCalStart;
	QCheckBox*	oCalStop;
	QCheckBox*	oInjection;
	QCheckBox*	oHChange;
	QCheckBox*	oFref;
	QCheckBox*	oState;	    // JMB
	QSpinBox*	oStateV;    // JMB
	
	QPushButton*	orefreshButton;
	QPushButton*	osaveButton;
	
	
	BGraphControlBasic*	ographControls;
	BFile		ofile;

};
#endif
