/*******************************************************************************
 *	Gui.cc		TapeSigGen Gui
 *			T.Barnaby,	BEAM Ltd,	2006-1-30
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <Gui.h>
#include <qpopupmenu.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qfiledialog.h>
#include <qvbox.h>
#include <qframe.h>
#include <qgrid.h>
#include <qlineedit.h>
#include <qgroupbox.h>
#include <qmessagebox.h>

Gui::Gui() : otests(testsInit()){
	otest = 0;
}


Gui::~Gui(){
}

void Gui::initMenubar(){

	QPopupMenu*	m;
	QAction*	a;
	m = new QPopupMenu();
	a = addAction(m, tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application"));
	menuBar()->insertItem(tr("&File"), m);

        menuBar( )->insertSeparator(-1);
	m = new QPopupMenu();
	a = addAction(m, tr("Manual"), tr("&Manual"), tr("Ctrl+M"), SLOT(manual()), tr("Online Manual"));
	a = addAction(m, tr("About"), tr("&About"), tr("Ctrl+A"), SLOT(about()), tr("About the program"));
	menuBar()->insertItem(tr("&Help"), m);

//	setMinimumSize(QSize(1024,850));
}


void Gui::initMain(){
	BError		err;
	QFont		font;
	QVBox*		vbox;
	QGroupBox*	g;
	QWidget*	w;
	BIter		i;

	font = qApp->font();
	font.setPointSize(10);
	qApp->setFont(font, true);

	vbox = new QVBox(this);

	// Settings	
	g = new QGroupBox(4, Horizontal, "Settings", vbox);
	g->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	g->setLineWidth(2);
	
	w = new QLabel("Type", g);
	owtype = new QComboBox(g);
	connect(owtype, SIGNAL(activated(const QString&)), this, SLOT(update()));
	for(otests.start(i); !otests.isEnd(i); otests.next(i)){
		owtype->insertItem(otests[i]->name().retStr());
	}

	w = new QLabel("Sample Frequency", g);
	owsampleFreq = new QLineEdit("150000000.0", g);
	owsampleFreq->setReadOnly(1);

	w = new QLabel("Signal Amplitude", g);
	owsignalAmplitude = new QLineEdit("1.0", g);
	
	// Info box
	g = new QGroupBox(1, Horizontal, "Info", vbox);
	g->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	g->setLineWidth(2);
	owinfo = new QTextEdit(g);
	owinfo->setReadOnly(1);
	owinfo->setMinimumHeight(50);
	
	// Control buttons
	g = new QGroupBox(2, Horizontal, "Controls", vbox);
	g->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	g->setLineWidth(2);
	owstartButton = new QPushButton("Start", g);
	connect(owstartButton, SIGNAL(clicked()), this, SLOT(startTest()));
	owstopButton = new QPushButton("Stop", g);
	connect(owstopButton, SIGNAL(clicked()), this, SLOT(stopTest()));
	
	setCentralWidget(vbox);

	update();
	owstartButton->setEnabled(true);
	owstopButton->setEnabled(false);
}

void Gui::initToolbar(){
}

void Gui::manual(){
	system("firefox /usr/tms/doc/index.html&");
}

void Gui::about(){
	BString		title = "<h3>TmsSigGenGui</h3>";
	BString		msg;
	
	msg = title + "<p>&copy; BEAM Ltd 2007</p><p>TMS Signal Generator Version: " + VERSION + "</p>";
	QMessageBox::information(this, "About", msg.retStr());
}

void* Gui::function(){
	BError		err;

	if(err = otest->run()){
		BString	msg = BString("Test init error: ") + err.getString();
		fprintf(stderr, "%s\n", msg.retStr());
		QMessageBox::warning(this, "Error", msg.retStr());
	}
	
	return 0;
}

void Gui::startTest(){
	BError		err;
	TestParams	params;

//	printf("Start\n");
	params.setValue("samplerate", owsampleFreq->text().ascii());
	params.setValue("amplitude", owsignalAmplitude->text().ascii());
	params.setValue("fref", "437000");
	params.setValue("cycleStartPhase", "45");

	if(err = otest->init(params)){
		BString	msg = BString("Test init error: ") + err.getString();
		fprintf(stderr, "%s\n", msg.retStr());
		QMessageBox::warning(this, "Error", msg.retStr());
		return;
	}
	
	owstartButton->setEnabled(false);
	owstopButton->setEnabled(true);
	start();
}

void Gui::stopTest(){
//	printf("Stop\n");
	cancel();
	waitForCompletion();
	otest->close();

	owstartButton->setEnabled(true);
	owstopButton->setEnabled(false);
}

void Gui::update(){
	BError	err;
	BIter	i;
	BString	s;
	
//	printf("Update\n");
	for(otests.start(i); !otests.isEnd(i); otests.next(i)){
		s = owtype->currentText().ascii();
		if(s.toLower() == otests[i]->name().toLower()){
			otest = otests[i];
			break;
		}
	}

	if(otest == 0){
		QMessageBox::warning(this, "Error", "Test not found");
		return;
	}
	else {
		owinfo->setText(otest->info().retStr());
	}
}
