/*******************************************************************************
 *	Light.cc	Light service
 *			T.Barnaby,	BEAM Ltd,	8/3/05
 *******************************************************************************
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <iostream>

#include <TestcaseD.h>
#include <TestcaseS.h>
#include <TestcaseC.h>


class LightServer : public Appliance::LightService {
public:
			LightServer(BoapServer& server, BString name) : Appliance::LightService(server, name){}
	BError		setLevel(Int32 level){
		BError	err;
		
		printf("LightServer::setLevel(%d)\n", level);
		sendEvent("lightChanged", level);
		printf("EventSent\n");
		return err;
	}
};


int main(int argc, char** argv){
	BoapServer		server;
	LightServer		light(server, "light");
	BError			err;

	
	if(err = server.init()){
		std::cerr << err.getString() << "\n";
		return 1;
	}
	
//	daemon(0, 0);

	server.run();
	
	return 0;
}
