/*
* Title:	Control.cpp
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Tms Client control. All Server request are routed through here.
*
* Mod Rec:
*
*/


#include <Control.h>
#include <iostream>
#include <Debug.h>

using namespace std;
using namespace Tms;

Control::Control() {
	ohostName = "localhost";
};

Control::~Control(){};
	
BError		Control::init() {					///< Initialise the system
	BError	err;
	err = connect();
	return err;
}

void	Control::setHost(BString host) {				///< Set host
	ohostName = host;
}

BError	Control::connect() {
	BError	err;

	dprintf(DBG_CONTROL,"Connecting to server - Disconnecting services\n");

	otmsControl.disconnectService();
	otmsProcess.disconnectService();
	dprintf(DBG_CONTROL,"Connecting to server - Services Disconnected\n");
	dprintf(DBG_CONTROL,"Connecting to boap object - (%s/tmsControl)\n",ohostName.retStr());
	
	if(err = otmsControl.connectService(BString("//") + ohostName + "/tmsControl")){
		cerr << "Error: cannot connect to tmsControl: " << err.getString() << "\n";
		return err;
	}
	dprintf(DBG_CONTROL,"Connecting to boap object - (%s/tmsProcess)\n",ohostName.retStr());
	if(err = otmsProcess.connectService(BString("//") + ohostName + "/tmsProcess")){
		cerr << "Error: cannot connect to tmsProcess: " << err.getString() << "\n";
		return err;
	}
	dprintf(DBG_CONTROL,"Connected to server objects\n");
	emit newConnection();
	return err;
}

BError	Control::reconfigure(Tms::ConfigInfo info) {			///< Reconfigure the system
	dprintf(DBG_CONTROL,"configure\n");
	return otmsControl.configure(info);
}

BError	Control::getConfiguration(Tms::ConfigInfo& info) {		
	dprintf(DBG_CONTROL,"getConfiguration\n");
	return otmsControl.getConfiguration(info);
}

BError	Control::setPupeConfig(Tms::PuChannel puChannel,Tms::PupeConfig pupeConfig) {
	dprintf(DBG_CONTROL,"setPupeConfig\n");
	return otmsControl.setPupeConfig(puChannel,pupeConfig);
}

BError	Control::getPupeConfig(Tms::PuChannel puChannel,Tms::PupeConfig& pupeConfig) {
	dprintf(DBG_CONTROL,"getPupeConfig\n");
	return otmsControl.getPupeConfig(puChannel,pupeConfig);
}


BError	Control::runTest(BList<BError>& l) {				///< Start the system running
	dprintf(DBG_CONTROL,"runTest\n");
	return otmsControl.test(l);
}


BError	Control::getTestData(PuChannel puPhysChannel, TestCaptureInfo captureInfo, BArray< UInt64 > &data) {
	dprintf(DBG_CONTROL,"getTestData\n");
	return otmsControl.captureDiagnostics(puPhysChannel,captureInfo,data);
}

BError	Control::getPuChannel (UInt32 puChannel, PuChannel &puPhysChannel){
	dprintf(DBG_CONTROL,"getPuChannel\n");
	return otmsControl.getPuChannel(puChannel,puPhysChannel);
}

BError	Control::setTestData(PuChannel puChannel,Int32 on, BArray<UInt32> data) {
	dprintf(DBG_CONTROL,"setTestData\n");
	return otmsControl.setTestData(puChannel,on,data);
}

BError	Control::getStatus(BList<Tms::NameValue>& l) {			///< Get Status
	dprintf(DBG_CONTROL,"getStatus\n");
	return otmsControl.getStatus(l);
}

BError	Control::getStatistics(BList<Tms::NameValue>& l) {		///< Get Statistics
	dprintf(DBG_CONTROL,"getStatistics\n");
	return otmsControl.getStatistics(l);
}

BError	Control::setSimulation(Tms::Simulation simulation){
	return otmsControl.setSimulation(simulation);
}

BError	Control::getSimulation(Tms::Simulation& simulation){
	return otmsControl.getSimulation(simulation);
}

BError	Control::initialiseServer() {
	dprintf(DBG_CONTROL,"init\n");
	return otmsControl.init();
}


BError	Control::getData(Tms::DataInfo info,Tms::Data& data) {				///< Get Data
	dprintf(DBG_CONTROL,"getData\n");
	return otmsProcess.getData(info,data);
}

BError	Control::setControlInfo(Tms::CycleParam	params) {				///< Setup cycle parameters
	dprintf(DBG_CONTROL,"setControlInfo\n");
	return otmsControl.setControlInfo(params);
}

BError  Control::getControlInfo(BString cycleType, UInt32 puChannel, Tms::CycleParam& params) {	///< Gets the control information for the cycle type and puChannel number given. The call will return an error object indicating success or an error
	dprintf(DBG_CONTROL,"getControlInfo\n");
	return otmsControl.getControlInfo(cycleType, puChannel,params);
}

BError  Control::delControlInfo(BString cycleType, UInt32 puChannel) {	///< Delets the control information for the cycle type and puChannel number given. The call will return an error object indicating success or an error
	dprintf(DBG_CONTROL,"delControlInfo\n");
	return otmsControl.delControlInfo(cycleType, puChannel);
}


BError	Control::getCycleInfo(UInt32& cycleNumber,BString& cycleType ) {
	dprintf(DBG_CONTROL,"getCycleInfo\n");
	return otmsProcess.getCycleInfo(cycleNumber,cycleType);
}


BError Control::getControlList(BList<CycleParamItem>& itemList) {	///< Gets the list of Cycle Parameters present in the system
	dprintf(DBG_CONTROL,"getControlList\n");
	return otmsControl.getControlList(itemList);
}


BError	Control::setNextCycle(UInt32 cycleNumber,BString cycleType) {
	dprintf(DBG_CONTROL,"setNextCycle (%d) (%s)\n",cycleNumber,cycleType.retStr());
	return otmsControl.setNextCycle(cycleNumber,cycleType);
}


