/*******************************************************************************
 *	Barrytest.cc	Test client
 *			T.Barnaby,	BEAM Ltd,	2007-03-09
 *******************************************************************************
 */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/time.h>
#include <BArray.h>

double getTime()
{
    struct timeval	tp;

    gettimeofday(&tp, NULL);
    return ((double) tp.tv_sec + (double) tp.tv_usec * 1e-6);
}

double func1(BArray<double>& a){
	double	v;
	
	v = a[100];
	
	return v;
}

void test1(){
	double		ts, te;
	int		n;
	int		num = 1000;
	double		r = 0;
	BArray<double>	array(1024*1024);
	
	ts = getTime();
	for(n = 0; n < num; n++){
		r += func1(array);
	}
	te = getTime();
	
	r = num / (te - ts);
	printf("Test1: %f Calls per sec %fms per call\n", r, 1000/r);
}

int main(int argc, char** argv){
	test1();
	
	return 0;
}
