/*******************************************************************************
 *	BCondTest.cpp	BEAM Class tests
 *			T.Barnaby,	Beam Ltd,	2007-02-06
 *******************************************************************************
 */

#include <BCondInt.h>

int	dec = 0;

void* thread(void* arg){
	BCondWrap*	c = (BCondWrap*)arg;
	
	while(1){
		sleep(1);
		if(dec){
			printf("ChangeTo: %d\n", c->value() - 1);
			c->decrement();
		}
		else {
			printf("ChangeTo: %d\n", c->value() + 1);
			c->increment();
		}
	}
	
	return 0;
}

int test1(){
	BCondWrap	c;
	uint32_t	v;
	int		n;
	int		e;
	int		d;
	pthread_t	t;

	c.setValue(-4);
	pthread_create(&t, 0, thread, &c);
	
	v = 4;
	
	for(n = 0; n < 4; n++){
		d = v - c.value();
		printf("Wait: %u %u Diff: %d\n", c.value(), v, d);
		e = c.waitMoreThanOrEqual(v);
		printf("Err: %d\n", e);
		v++;
	}
	
	dec = 1;
	
	v = 0;
	for(n = 0; n < 10; n++){
		d = v - c.value();
		printf("Wait: %u %u Diff: %d\n", c.value(), v, d);
		e = c.waitLessThanOrEqual(v);
		printf("Err: %d\n", e);
	}

	v = -4;
	for(n = 0; n < 10; n++){
		d = v - c.value();
		printf("Wait: %u %u Diff: %d\n", c.value(), v, d);
		e = c.waitLessThanOrEqual(v);
		printf("Err: %d\n", e);
	}
	return 0;
}


int test2(){
	uint32_t	v = -4;
	uint32_t	c = 0;
	int		d;
	int		n;
	
	for(n = 0; n < 8; n++){
		d = v - c;
		printf("Diff: %d\n", d);
		v++;
	}
}

int main(int argc, char** argv){

	test1();
//	test2();
	
	return 0;
}
