/*******************************************************************************
 *	Boapns.cc	Produced by Bidl
 *******************************************************************************
 */

#include <BoapnsC.h>

namespace Boapns {
	Boapns::Boapns(BString name) : BoapClientObject(name){
		oapiVersion = 1;
	}
	BError Boapns::getVersion(BString& version){
		BError	err;
		BError	ret;
		BoapPacketHead	txhead;
		BoapPacketHead	rxhead;
		
		olock.lock();
		if(err = connectService(oname)){
			olock.unlock();
			return err;
		}
		
		txhead.type = BoapTypeRpc;
		txhead.service = oservice;
		txhead.cmd = 16;
		otx.pushHead(txhead);
		if(err = performCall(otx, orx)){
			olock.unlock();
			return err;
		}
		orx.popHead(rxhead);
		orx.pop(ret);
		orx.pop(version);
		olock.unlock();
		return ret;
	}

	BError Boapns::getEntryList(BList<BoapEntry>& entryList){
		BError	err;
		BError	ret;
		BoapPacketHead	txhead;
		BoapPacketHead	rxhead;
		
		olock.lock();
		if(err = connectService(oname)){
			olock.unlock();
			return err;
		}
		
		txhead.type = BoapTypeRpc;
		txhead.service = oservice;
		txhead.cmd = 17;
		otx.pushHead(txhead);
		if(err = performCall(otx, orx)){
			olock.unlock();
			return err;
		}
		orx.popHead(rxhead);
		orx.pop(ret);
		{
			Int32 n0;
			BoapEntry v0;
			entryList.clear();
			orx.pop(n0);
			while(n0--){
				orx.pop(v0.name);
				orx.pop(v0.hostName);
				{
					Int32 n1;
					BString v1;
					v0.addressList.clear();
					orx.pop(n1);
					while(n1--){
						orx.pop(v1);
						v0.addressList.append(v1);
					}
				}
				orx.pop(v0.port);
				orx.pop(v0.service);
				entryList.append(v0);
			}
		}
		olock.unlock();
		return ret;
	}

	BError Boapns::getEntry(BString name, BoapEntry& entry){
		BError	err;
		BError	ret;
		BoapPacketHead	txhead;
		BoapPacketHead	rxhead;
		
		olock.lock();
		if(err = connectService(oname)){
			olock.unlock();
			return err;
		}
		
		txhead.type = BoapTypeRpc;
		txhead.service = oservice;
		txhead.cmd = 18;
		otx.pushHead(txhead);
		otx.push(name);
		if(err = performCall(otx, orx)){
			olock.unlock();
			return err;
		}
		orx.popHead(rxhead);
		orx.pop(ret);
		orx.pop(entry.name);
		orx.pop(entry.hostName);
		{
			Int32 n0;
			BString v0;
			entry.addressList.clear();
			orx.pop(n0);
			while(n0--){
				orx.pop(v0);
				entry.addressList.append(v0);
			}
		}
		orx.pop(entry.port);
		orx.pop(entry.service);
		olock.unlock();
		return ret;
	}

	BError Boapns::addEntry(BoapEntry entry){
		BError	err;
		BError	ret;
		BoapPacketHead	txhead;
		BoapPacketHead	rxhead;
		
		olock.lock();
		if(err = connectService(oname)){
			olock.unlock();
			return err;
		}
		
		txhead.type = BoapTypeRpc;
		txhead.service = oservice;
		txhead.cmd = 19;
		otx.pushHead(txhead);
		otx.push(entry.name);
		otx.push(entry.hostName);
		{
			BIter i0;
			otx.push(entry.addressList.number());
			for(i0 = entry.addressList.begin(); !entry.addressList.isEnd(i0); entry.addressList.next(i0)){
				otx.push(entry.addressList[i0]);
			}
		}
		otx.push(entry.port);
		otx.push(entry.service);
		if(err = performCall(otx, orx)){
			olock.unlock();
			return err;
		}
		orx.popHead(rxhead);
		orx.pop(ret);
		olock.unlock();
		return ret;
	}

	BError Boapns::delEntry(BString name){
		BError	err;
		BError	ret;
		BoapPacketHead	txhead;
		BoapPacketHead	rxhead;
		
		olock.lock();
		if(err = connectService(oname)){
			olock.unlock();
			return err;
		}
		
		txhead.type = BoapTypeRpc;
		txhead.service = oservice;
		txhead.cmd = 20;
		otx.pushHead(txhead);
		otx.push(name);
		if(err = performCall(otx, orx)){
			olock.unlock();
			return err;
		}
		orx.popHead(rxhead);
		orx.pop(ret);
		olock.unlock();
		return ret;
	}

	BError Boapns::getNewName(BString& name){
		BError	err;
		BError	ret;
		BoapPacketHead	txhead;
		BoapPacketHead	rxhead;
		
		olock.lock();
		if(err = connectService(oname)){
			olock.unlock();
			return err;
		}
		
		txhead.type = BoapTypeRpc;
		txhead.service = oservice;
		txhead.cmd = 21;
		otx.pushHead(txhead);
		if(err = performCall(otx, orx)){
			olock.unlock();
			return err;
		}
		orx.popHead(rxhead);
		orx.pop(ret);
		orx.pop(name);
		olock.unlock();
		return ret;
	}

}
