/*
* Title:	OptionsWin.cpp
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-14
*
* Contents:	Option Control and Dialogs.
*
* Mod Rec:
*/


#include <OptionsWin.h>
#include <qlistbox.h>
#include <qlayout.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qhbox.h>
#include <Globals.h>



OptionsWin::OptionsWin(QWidget* parent, Control& c) : ocontrol(c) {
	QGridLayout*	g = new QGridLayout(this,2,2,0,-1,"grid");
	QWidget*	b = new QWidget(this,"buttons");
	QHBoxLayout*	h  = new QHBoxLayout(b,0,-1,"hbox");
	QPushButton*	ok = new QPushButton("Ok",b,"buttonok");
	QPushButton*	cancel = new QPushButton("Cancel",b,"buttonlcancel");
	QSpacerItem*	spacer = new QSpacerItem(20,20,QSizePolicy::Expanding, QSizePolicy::Minimum );

	owidgetStack = new QWidgetStack(this,"stack");
	olistBox = new QListBox(this,"list");

	setSizeGripEnabled(false);

 	cancel->setAutoDefault(true);

	h->addItem(spacer);
	h->addWidget(ok);
	h->addWidget(cancel);
	
	g->addWidget(olistBox,0,0);
	g->addWidget(owidgetStack,0,1);
	g->addMultiCellWidget(b,1,1,0,1);

	
	odataOptions = new DataOptions(this,ocontrol);
	
	owidgetStack->addWidget(odataOptions);
	owidgetStack->raiseWidget(odataOptions);
	
	olistBox->clear();
	olistBox->insertItem("Capture Options");
	olistBox->setSelected(0,true);
	olistBox->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)7, 0, 0,olistBox->sizePolicy().hasHeightForWidth() ) );
	connect(cancel,SIGNAL(clicked()),this,SLOT(reject()));
	connect(ok,SIGNAL(clicked()),this,SLOT(accept()));
	connect(olistBox, SIGNAL(clicked(QListBoxItem*)), this, SLOT(selected()));
}
OptionsWin::~OptionsWin() {}

void OptionsWin::show() {
	odataOptions->set();
	QDialog::show();
}

void OptionsWin::accept() {
	odataOptions->save();
	QDialog::accept();
}

void OptionsWin::selected() {
        int     selected = olistBox->currentItem();
	
        switch (selected) {
                case 0:         owidgetStack->raiseWidget(odataOptions);   break;
                default:        owidgetStack->raiseWidget(odataOptions);   break;
        }
}

DataOptions::DataOptions(QWidget* parent,Control& c) : ocontrol(c) {
	QWidget*	page;
	QGridLayout*	grid;
	QLabel*		defaultServerLabel;
	
	page = new QWidget(this,"Basic");
	this->insertTab(page,"Basic");
	
        grid = new QGridLayout(page,5,3);
        grid->setMargin(20);
        grid->setSpacing(20);

	defaultServerLabel = new QLabel(page,"Default Server");
	defaultServerLabel->setText("Default Server");
	odefaultServer = new QLineEdit(page,"defaultServer");
	
	grid->addWidget(defaultServerLabel,0,0);
	grid->addWidget(odefaultServer,0,1);
}

DataOptions::~DataOptions() {}

void DataOptions::set() {
	BString	s;
	
	s = gconfig.findValue("DefaultServer:");
	odefaultServer->setText(s.retStr());
}
void DataOptions::save() {
	gconfig.setValue("DefaultServer:",odefaultServer->text());
	gconfig.write();
}
